/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCommonService;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import org.slf4j.LoggerFactory;

public class SdkmsCertificateService {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsCertificateService.class));

    public static KeyObject importCertificate(Certificate certificate, String objectName, String groupId) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(null, null, null, "CERTIFICATE");
            sObjReq.setValue(certificate.getEncoded());
            if (objectName != null) {
                sObjReq.setName(objectName);
            }
            if (groupId != null) {
                sObjReq.setGroupId(groupId);
            }
            keyObject = SdkmsCommonService.importKeyForAlgorithm(sObjReq, "CERTIFICATE");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during importing certificate", apiException);
        }
        catch (CertificateEncodingException e) {
            LOGGER.logAndRaiseProviderException("Certificate Encoding error", e);
        }
        return keyObject;
    }
}

