/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SecurityObjectRequest;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.List;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public class SdkmsCommonService {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsCommonService.class));

    public static SobjectRequest getSObjectRequestForAlgorithm(Integer keySize, List<KeyOperations> allowedKeyOps, Boolean isTransientKey, String algo) {
        ObjectType objType = SdkmsCommonService.getObjectTypeForAlgo(algo);
        SobjectRequest sObjectReq = new SobjectRequest();
        if (objType != null) {
            String securityObjectName = UUID.randomUUID().toString();
            sObjectReq.setName(securityObjectName);
            sObjectReq.setObjType(objType);
            sObjectReq.enabled(Boolean.valueOf(true));
            sObjectReq.setKeySize(keySize);
            if (allowedKeyOps != null) {
                sObjectReq.setKeyOps(allowedKeyOps);
            }
            if (isTransientKey != null) {
                sObjectReq.setTransient(isTransientKey);
            }
        }
        return sObjectReq;
    }

    public static KeyObject generateKeyForAlgorithm(SobjectRequest sObjectReq, String algo) throws ApiException {
        KeyObject keyObject = null;
        try {
            keyObject = new SecurityObjectRequest().makeGenerate(sObjectReq);
        }
        catch (ApiException apiException) {
            LOGGER.debug("Error during " + algo + " Key generation : " + (Object)((Object)apiException), apiException);
            throw apiException;
        }
        return keyObject;
    }

    public static KeyObject importKeyForAlgorithm(SobjectRequest sObjectReq, String algo) throws ApiException {
        KeyObject keyObject = null;
        try {
            keyObject = new SecurityObjectRequest().makeImport(sObjectReq);
        }
        catch (ApiException apiException) {
            LOGGER.debug("Error during " + algo + " Key import : " + (Object)((Object)apiException), apiException);
            throw apiException;
        }
        return keyObject;
    }

    public static ObjectType getObjectTypeForAlgo(String algo) {
        switch (algo) {
            case "AES": {
                return ObjectType.AES;
            }
            case "DES": {
                return ObjectType.DES;
            }
            case "DESede": {
                return ObjectType.DES3;
            }
            case "DSA": {
                return ObjectType.DSA;
            }
            case "EC": {
                return ObjectType.EC;
            }
            case "HMAC": {
                return ObjectType.HMAC;
            }
            case "RSA": {
                return ObjectType.RSA;
            }
            case "CERTIFICATE": {
                return ObjectType.CERTIFICATE;
            }
        }
        return null;
    }
}

