/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.keys.SdkmsKey;
import com.fortanix.sdkms.jce.provider.keys.asym.elliptic.ECPrivateKeyImpl;
import com.fortanix.sdkms.jce.provider.keys.asym.elliptic.ECPublicKeyImpl;
import com.fortanix.sdkms.jce.provider.keys.asym.rsa.RSAPrivateKeyImpl;
import com.fortanix.sdkms.jce.provider.keys.asym.rsa.RSAPublicKeyImpl;
import com.fortanix.sdkms.jce.provider.keys.sym.aes.SdkmsAESKey;
import com.fortanix.sdkms.jce.provider.keys.sym.des.SdkmsDESKey;
import com.fortanix.sdkms.jce.provider.keys.sym.desede.SdkmsDESedeKey;
import com.fortanix.sdkms.jce.provider.macs.SdkmsHmacKey;
import com.fortanix.sdkms.jce.provider.service.ApiClientSetup;
import com.fortanix.sdkms.jce.provider.service.ISdkmsCommand;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SecurityObjectRequest;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.api.SecurityObjectsApi;
import com.fortanix.sdkms.v1.model.AgreeKeyRequest;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.PersistTransientKeyRequest;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public final class SdkmsKeyService {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsKeyService.class));
    private static final int GET_SOBJECTS_LIMIT = 1000;

    public static KeyObject toKeyObject(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("No Key given");
        }
        if (key instanceof SdkmsKey) {
            SdkmsKey sdkmsKey = (SdkmsKey)((Object)key);
            return SdkmsKeyService.getKeyObject(sdkmsKey.getKeyDescriptor());
        }
        throw new InvalidKeyException("Key is not a valid SDKMS Key");
    }

    public static KeyObject getKeyObject(final SobjectDescriptor descriptor) {
        if (descriptor.getKid() != null) {
            try {
                KeyObject keyObject = (KeyObject)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                    @Override
                    public Object execute() throws ApiException {
                        return new SecurityObjectsApi(ApiClientSetup.getInstance().getApiClient()).getSecurityObject(descriptor.getKid(), "json", Boolean.valueOf(false), Boolean.valueOf(false));
                    }

                    @Override
                    public String getDescription() {
                        return "GetSecurityObject";
                    }
                });
                return keyObject;
            }
            catch (ApiException apiException) {
                LOGGER.logAndRaiseProviderException("Failed to find Key in SDKMS", apiException);
            }
        } else if (descriptor.getName() != null) {
            return SdkmsKeyService.getSecurityObjectByName(descriptor.getName());
        }
        LOGGER.logAndRaiseProviderException("Key lookup failed: id or name missing", null);
        return null;
    }

    public static ObjectType toSDKMSAlgorithm(String jceAlgorithm) {
        if (jceAlgorithm.equalsIgnoreCase("DESede") || jceAlgorithm.equalsIgnoreCase("TripleDES")) {
            return ObjectType.DES3;
        }
        return ObjectType.fromValue((String)jceAlgorithm.toUpperCase());
    }

    public static List<KeyObject> getKeys(String name, String groupId, String creator) {
        ArrayList<KeyObject> keyObjects = new ArrayList<KeyObject>();
        try {
            List result;
            int offset = 0;
            while ((result = (List)ApiClientSetup.getInstance().ensureValidSession(new GetSobjectsCommand(name, groupId, creator, null, null, null, 1000, offset))) != null && result.size() != 0) {
                keyObjects.addAll(result);
                if (result.size() != 1000) break;
                offset += 1000;
            }
            SdkmsKeyService.filterKeys(keyObjects, Arrays.asList(ObjectType.SECRET));
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error retrieving keys", apiException);
        }
        return keyObjects;
    }

    private static void filterKeys(List<KeyObject> keys, List<ObjectType> objectTypesToBeRemoved) {
        ArrayList toBeRemovedIndices = new ArrayList();
        if (objectTypesToBeRemoved == null || objectTypesToBeRemoved.size() == 0) {
            return;
        }
        Iterator<KeyObject> iter = keys.iterator();
        block0: while (iter.hasNext()) {
            KeyObject key = iter.next();
            for (ObjectType objectType : objectTypesToBeRemoved) {
                if (!objectType.equals(key.getObjType())) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    public static void deleteKey(final String keyId) {
        try {
            ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    new SecurityObjectsApi(ApiClientSetup.getInstance().getApiClient()).deleteSecurityObject(keyId);
                    return null;
                }

                @Override
                public String getDescription() {
                    return "DeleteSecurityObject";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error deleting key", apiException);
        }
    }

    public static KeyObject updateKey(SobjectDescriptor key, String newName, Map<String, String> metaData) {
        KeyObject outKeyObject = null;
        String keyId = key.getKid();
        if (key.getKid() == null && key.getName() != null) {
            KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(key.getName());
            keyId = keyObject.getKid();
        }
        try {
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.setName(newName);
            if (metaData != null) {
                securityObjectRequest.setCustomMetadata(metaData);
            }
            outKeyObject = new SecurityObjectRequest().makeUpdate(keyId, securityObjectRequest);
            return outKeyObject;
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during updating key", apiException);
            return outKeyObject;
        }
    }

    public static KeyObject persistKey(Key key, String name, Map<String, String> metaData) {
        KeyObject outKeyObject = null;
        try {
            PersistTransientKeyRequest persistTransientKeyRequest = new PersistTransientKeyRequest();
            persistTransientKeyRequest.setName(name);
            persistTransientKeyRequest.setTransientKey(((SdkmsKey)((Object)key)).getKeyDescriptor().getTransientKey());
            if (metaData != null) {
                persistTransientKeyRequest.setCustomMetadata(metaData);
            }
            outKeyObject = new SecurityObjectRequest().persistTransient(persistTransientKeyRequest);
            return outKeyObject;
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during persisting key", apiException);
            return outKeyObject;
        }
    }

    public static KeyObject agreeKey(final AgreeKeyRequest agreeKeyRequest) throws InvalidKeyException {
        KeyObject keyObject = null;
        try {
            keyObject = (KeyObject)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new SecurityObjectsApi(ApiClientSetup.getInstance().getApiClient()).agreeKey(agreeKeyRequest);
                }

                @Override
                public String getDescription() {
                    return "AgreeKey";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Failed to perform key agreement", apiException);
        }
        return keyObject;
    }

    public static byte[] getKeyValue(String keyId) {
        return SdkmsKeyService.getKeyValue(new SobjectDescriptor().kid(keyId));
    }

    public static byte[] getKeyValue(final SobjectDescriptor descriptor) {
        try {
            KeyObject keyObject = (KeyObject)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new SecurityObjectsApi(ApiClientSetup.getInstance().getApiClient()).getSecurityObjectValueEx(descriptor);
                }

                @Override
                public String getDescription() {
                    return "GetSecurityObjectValue(exportKey)";
                }
            });
            if (keyObject == null) {
                LOGGER.error("Key export failed as key doesn't exist: " + descriptor, null);
                return null;
            }
            return keyObject.getValue();
        }
        catch (ApiException apiException) {
            LOGGER.error("Key export failed for key " + descriptor, apiException);
            return null;
        }
    }

    public static KeyObject getSecurityObjectByName(String name) {
        List<KeyObject> keyObjects = SdkmsKeyService.getKeys(name, null, null);
        if (keyObjects == null || keyObjects.isEmpty()) {
            return null;
        }
        return keyObjects.get(0);
    }

    public static Key getKeyFromKeyObject(KeyObject keyObject, boolean isPublic) throws InvalidKeyException {
        ObjectType objectType = keyObject.getObjType();
        if (ObjectType.RSA.equals(objectType)) {
            if (isPublic) {
                return new RSAPublicKeyImpl(keyObject);
            }
            return new RSAPrivateKeyImpl(keyObject);
        }
        if (ObjectType.EC.equals(objectType)) {
            if (isPublic) {
                return new ECPublicKeyImpl(keyObject);
            }
            return new ECPrivateKeyImpl(keyObject);
        }
        if (ObjectType.AES.equals(objectType)) {
            return new SdkmsAESKey(keyObject);
        }
        if (ObjectType.DES.equals(objectType)) {
            return new SdkmsDESKey(keyObject);
        }
        if (ObjectType.DES3.equals(objectType)) {
            return new SdkmsDESedeKey(keyObject);
        }
        if (ObjectType.HMAC.equals(objectType)) {
            switch (keyObject.getKeySize()) {
                case 160: {
                    return new SdkmsHmacKey(keyObject, "HmacSHA1");
                }
                case 256: {
                    return new SdkmsHmacKey(keyObject, "HmacSHA256");
                }
                case 384: {
                    return new SdkmsHmacKey(keyObject, "HmacSHA384");
                }
                case 512: {
                    return new SdkmsHmacKey(keyObject, "HmacSHA512");
                }
            }
        }
        throw new InvalidKeyException("Key of type: " + keyObject.getKeySize() + ", key size: " + keyObject.getKeySize() + " is not supported");
    }

    public static RSAPublicKey getRSAPublicKey(KeyObject keyObject) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(keyObject.getPubKey());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "SunRsaSign");
        return (RSAPublicKey)keyFactory.generatePublic(pubKeySpec);
    }

    public static ECParameterSpec getECPrivateKeyParams(KeyObject keyObject) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        com.fortanix.sdkms.v1.model.EllipticCurve curve_id = keyObject.getEllipticCurve();
        Object params = null;
        if (curve_id == com.fortanix.sdkms.v1.model.EllipticCurve.GOST256A) {
            BigInteger p = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD97", 16);
            BigInteger a = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD94", 16);
            BigInteger b = new BigInteger("A6", 16);
            BigInteger n = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF6C611070995AD10045841B09B761B893", 16);
            BigInteger g_x = new BigInteger("1", 16);
            BigInteger g_y = new BigInteger("8D91E471E0989CDA27DF505A453F2B7635294F2DDF23E3B122ACC99C9E9F1E14", 16);
            int h = 1;
            ECFieldFp field = new ECFieldFp(p);
            EllipticCurve curve = new EllipticCurve(field, a, b);
            ECPoint generator = new ECPoint(g_x, g_y);
            return new ECParameterSpec(curve, generator, n, h);
        }
        if (curve_id == com.fortanix.sdkms.v1.model.EllipticCurve.ED25519) {
            BigInteger p = new BigInteger("7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFED", 16);
            BigInteger a = new BigInteger("2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA984914A144", 16);
            BigInteger b = new BigInteger("7B425ED097B425ED097B425ED097B425ED097B425ED097B4260B5E9C7710C864", 16);
            BigInteger n = new BigInteger("1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED", 16);
            BigInteger g_x = new BigInteger("2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD245A", 16);
            BigInteger g_y = new BigInteger("20AE19A1B8A086B4E01EDD2C7748D14C923D4D7E6D7C61B229E9C5A27ECED3D9", 16);
            int h = 8;
            ECFieldFp field = new ECFieldFp(p);
            EllipticCurve curve = new EllipticCurve(field, a, b);
            ECPoint generator = new ECPoint(g_x, g_y);
            return new ECParameterSpec(curve, generator, n, h);
        }
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(keyObject.getPubKey());
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "SunEC");
        ECPublicKey pubKey = (ECPublicKey)keyFactory.generatePublic(pubKeySpec);
        return pubKey.getParams();
    }

    public static SobjectDescriptor getKeyDescriptor(KeyObject keyObject) {
        return new SobjectDescriptor().kid(keyObject.getKid()).transientKey(keyObject.getTransientKey());
    }

    private static class GetSobjectsCommand
    implements ISdkmsCommand {
        String name;
        String groupId;
        String creator;
        String sort;
        Boolean compliantWithPolicies;
        String start;
        Integer limit;
        Integer offset;

        public GetSobjectsCommand(String name, String groupId, String creator, String sort, Boolean compliantWithPolicies, String start, Integer limit, Integer offset) {
            this.name = name;
            this.groupId = groupId;
            this.creator = creator;
            this.sort = sort;
            this.compliantWithPolicies = compliantWithPolicies;
            this.start = start;
            this.limit = limit;
            this.offset = offset;
        }

        @Override
        public Object execute() throws ApiException {
            return new SecurityObjectsApi(ApiClientSetup.getInstance().getApiClient()).getSecurityObjects(this.name, this.groupId, this.creator, this.sort, this.compliantWithPolicies, this.start, this.limit, this.offset, Boolean.valueOf(false), Boolean.valueOf(false));
        }

        @Override
        public String getDescription() {
            return "GetSecurityObjects";
        }
    }
}

