/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.signatures;

import com.fortanix.sdkms.jce.provider.config.Configuration;
import com.fortanix.sdkms.jce.provider.constants.DigestAlgorithms;
import com.fortanix.sdkms.jce.provider.keys.asym.elliptic.ECPrivateKeyImpl;
import com.fortanix.sdkms.jce.provider.keys.asym.elliptic.ECPublicKeyImpl;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.signatures.SdkmsSignatureService;
import com.fortanix.sdkms.v1.model.SignResponse;
import com.fortanix.sdkms.v1.model.VerifyResponse;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import org.slf4j.LoggerFactory;

abstract class ECDSASignature
extends SignatureSpi {
    private MessageDigest messageDigest;
    private boolean needsReset;
    private ECPrivateKeyImpl privateKey;
    private ECPublicKeyImpl publicKey;
    private DigestAlgorithms digestAlgorithm;
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(ECDSASignature.class));

    ECDSASignature() {
        this.messageDigest = null;
    }

    ECDSASignature(String digestName) {
        this.digestAlgorithm = DigestAlgorithms.getByKey(digestName);
        if (this.digestAlgorithm == null) {
            LOGGER.logAndRaiseProviderException("The digest algorithm " + digestName + " is not supported", null);
        }
        this.messageDigest = null;
        try {
            this.messageDigest = MessageDigest.getInstance(digestName, Configuration.getInstance().getProviderName());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOGGER.logAndRaiseProviderException(e.getMessage(), e);
        }
        this.needsReset = false;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        LOGGER.debug("ECDSASignature: verify init");
        if (!(publicKey instanceof ECPublicKeyImpl)) {
            throw new InvalidKeyException("Only ECPublicKeyImpl is supported");
        }
        this.publicKey = (ECPublicKeyImpl)publicKey;
        this.privateKey = null;
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        LOGGER.debug("ECDSASignature: sign init");
        if (!(privateKey instanceof ECPrivateKeyImpl)) {
            throw new InvalidKeyException("Only ECPrivateKeyImpl is supported");
        }
        this.privateKey = (ECPrivateKeyImpl)privateKey;
        this.publicKey = null;
        this.resetDigest();
    }

    protected void resetDigest() {
        if (this.needsReset) {
            if (this.messageDigest != null) {
                this.messageDigest.reset();
            }
            this.needsReset = false;
        }
    }

    protected byte[] getDigestValue() throws SignatureException {
        this.needsReset = false;
        return this.messageDigest.digest();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        LOGGER.debug("ECDSASignature: sign update");
        this.messageDigest.update(b);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        LOGGER.debug("ECDSASignature: sign update");
        this.messageDigest.update(b, off, len);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        LOGGER.debug("ECDSASignature: sign update");
        int len = byteBuffer.remaining();
        if (len <= 0) {
            return;
        }
        this.messageDigest.update(byteBuffer);
        this.needsReset = true;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        LOGGER.debug("ECDSASignature: sign final");
        byte[] digest = this.getDigestValue();
        SignResponse signResponse = SdkmsSignatureService.signDigest(digest, this.digestAlgorithm.getValue(), this.privateKey.getKeyDescriptor(), null);
        return signResponse.getSignature();
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        LOGGER.debug("ECDSASignature: verify final");
        byte[] digest = this.getDigestValue();
        VerifyResponse verifyResponse = SdkmsSignatureService.verifyDigest(signature, digest, this.digestAlgorithm.getValue(), this.publicKey.getKeyDescriptor(), null);
        return verifyResponse.getResult();
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    public static final class Streebog512withEC
    extends ECDSASignature {
        public Streebog512withEC() {
            super("Streebog-512");
            LOGGER.debug("ECDSASignature: being initialized for Streebog512withECDSA");
        }
    }

    public static final class Streebog256withEC
    extends ECDSASignature {
        public Streebog256withEC() {
            super("Streebog-256");
            LOGGER.debug("ECDSASignature: being initialized for Streebog256withECDSA");
        }
    }

    public static final class SHA512withEC
    extends ECDSASignature {
        public SHA512withEC() {
            super("SHA-512");
            LOGGER.debug("ECDSASignature: being initialized for SHA512withECDSA");
        }
    }

    public static final class SHA384withEC
    extends ECDSASignature {
        public SHA384withEC() {
            super("SHA-384");
            LOGGER.debug("ECDSASignature: being initialized for SHA384withECDSA");
        }
    }

    public static final class SHA256withEC
    extends ECDSASignature {
        public SHA256withEC() {
            super("SHA-256");
            LOGGER.debug("ECDSASignature: being initialized for SHA256withECDSA");
        }
    }

    public static final class SHA1withEC
    extends ECDSASignature {
        public SHA1withEC() {
            super("SHA1");
            LOGGER.debug("ECDSASignature: being initialized for SHA1withECDSA");
        }
    }
}

