/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.signatures;

import com.fortanix.sdkms.jce.provider.config.Configuration;
import com.fortanix.sdkms.jce.provider.constants.DigestAlgorithms;
import com.fortanix.sdkms.jce.provider.keys.asym.rsa.RSAPrivateKeyImpl;
import com.fortanix.sdkms.jce.provider.keys.asym.rsa.RSAPublicKeyImpl;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.signatures.SdkmsSignatureService;
import com.fortanix.sdkms.v1.model.Mgf;
import com.fortanix.sdkms.v1.model.MgfMgf1;
import com.fortanix.sdkms.v1.model.RsaSignaturePaddingPSS;
import com.fortanix.sdkms.v1.model.SignResponse;
import com.fortanix.sdkms.v1.model.SignatureMode;
import com.fortanix.sdkms.v1.model.VerifyResponse;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.slf4j.LoggerFactory;

public abstract class RSASignature
extends SignatureSpi {
    private MessageDigest md = null;
    private boolean digestReset;
    private RSAPrivateKeyImpl privateKey;
    private RSAPublicKeyImpl publicKey;
    private DigestAlgorithms digestAlgorithm;
    private DigestAlgorithms pssDigestAlgorithm;
    private String transientKey;
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(RSASignature.class));

    RSASignature(String digestAlgorithm) {
        LOGGER.debug("Initializing RSA Signature");
        this.digestAlgorithm = DigestAlgorithms.getByKey(digestAlgorithm);
        if (this.digestAlgorithm == null) {
            throw new ProviderException("The digest algorithm " + digestAlgorithm + " is not supported");
        }
        try {
            this.md = MessageDigest.getInstance(digestAlgorithm, Configuration.getInstance().getProviderName());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOGGER.logAndRaiseProviderException("Failed to initialize RSA Signature", e);
        }
        this.digestReset = true;
    }

    protected void setPssDigestAlgorithm(String pssDigestAlgorithm) {
        this.pssDigestAlgorithm = DigestAlgorithms.getByKey(pssDigestAlgorithm);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        LOGGER.debug("RSA Signature: verify init");
        if (!(publicKey instanceof RSAPublicKeyImpl)) {
            throw new InvalidKeyException("Key is not of type RSAPublicImpl");
        }
        this.privateKey = null;
        this.publicKey = (RSAPublicKeyImpl)publicKey;
        this.initCommon(this.publicKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        LOGGER.debug("RSA Signature: sign init");
        if (!(privateKey instanceof RSAPrivateKeyImpl)) {
            throw new InvalidKeyException("Key is not of type RSAPublicImpl");
        }
        this.privateKey = (RSAPrivateKeyImpl)privateKey;
        this.publicKey = null;
        this.initCommon(this.privateKey, random);
    }

    private void initCommon(RSAKey rsaKey, SecureRandom random) throws InvalidKeyException {
        this.resetDigest();
    }

    private void resetDigest() {
        if (!this.digestReset) {
            this.md.reset();
            this.digestReset = true;
        }
    }

    private byte[] getDigestValue() {
        this.digestReset = true;
        return this.md.digest();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        LOGGER.debug("RSA Signature: sign update");
        this.md.update(b);
        this.digestReset = false;
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        LOGGER.debug("RSA Signature: sign update");
        this.md.update(b, off, len);
        this.digestReset = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer b) {
        LOGGER.debug("RSA Signature: sign update");
        this.md.update(b);
        this.digestReset = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        LOGGER.debug("RSA Signature: sign final");
        byte[] digest = this.getDigestValue();
        SignResponse signResponse = SdkmsSignatureService.signDigest(digest, this.digestAlgorithm.getValue(), this.privateKey.getKeyDescriptor(), this.getSignatureMode());
        return signResponse.getSignature();
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        LOGGER.debug("RSA Signature: verify final");
        byte[] digest = this.getDigestValue();
        VerifyResponse verifyResponse = SdkmsSignatureService.verifyDigest(sigBytes, digest, this.digestAlgorithm.getValue(), this.publicKey.getKeyDescriptor(), this.getSignatureMode());
        return verifyResponse.getResult();
    }

    private SignatureMode getSignatureMode() {
        SignatureMode signatureMode = new SignatureMode();
        if (this.pssDigestAlgorithm == null) {
            signatureMode.setPkCS1V15(new Object());
            return signatureMode;
        }
        signatureMode.setPSS(new RsaSignaturePaddingPSS().mgf(new Mgf().mgf1(new MgfMgf1().hash(this.pssDigestAlgorithm.getValue()))));
        return signatureMode;
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        LOGGER.logAndRaiseProviderException("method setParameter() not supported", null);
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        LOGGER.logAndRaiseProviderException("method getParameter() not supported", null);
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec parameterSpec) throws InvalidAlgorithmParameterException {
        if (parameterSpec instanceof PSSParameterSpec) {
            PSSParameterSpec pssParamaterSpec = (PSSParameterSpec)parameterSpec;
            if (DigestAlgorithms.getByKey(pssParamaterSpec.getDigestAlgorithm()) != null) {
                this.digestAlgorithm = DigestAlgorithms.getByKey(pssParamaterSpec.getDigestAlgorithm());
            }
            if (pssParamaterSpec.getMGFParameters() != null) {
                MGF1ParameterSpec mgf1ParameterSpec = (MGF1ParameterSpec)pssParamaterSpec.getMGFParameters();
                this.pssDigestAlgorithm = DigestAlgorithms.getByKey(mgf1ParameterSpec.getDigestAlgorithm());
            }
            return;
        }
        throw new InvalidAlgorithmParameterException();
    }

    public static final class SHA512withRSAandPKCSV15
    extends RSASignature {
        public SHA512withRSAandPKCSV15() {
            super("SHA-512");
            LOGGER.debug("RSASignature: being initialized for SHA512withRSAandPKCSV1_5");
        }
    }

    public static final class SHA384withRSAandPKCSV15
    extends RSASignature {
        public SHA384withRSAandPKCSV15() {
            super("SHA-384");
            LOGGER.debug("RSASignature: being initialized for SHA384withRSAandPKCSV1_5");
        }
    }

    public static final class SHA256withRSAandPKCSV15
    extends RSASignature {
        public SHA256withRSAandPKCSV15() {
            super("SHA-256");
            LOGGER.debug("RSASignature: being initialized for SHA256withRSAandPKCSV1_5");
        }
    }

    public static final class SHA1withRSAandPKCSV15
    extends RSASignature {
        public SHA1withRSAandPKCSV15() {
            super("SHA1");
            LOGGER.debug("RSASignature: being initialized for SHA1withRSAandPKCSV1_5");
        }
    }

    public static final class SHA512withRSAandMGF1
    extends RSASignature {
        public SHA512withRSAandMGF1() {
            super("SHA-512");
            this.setPssDigestAlgorithm("SHA-512");
            LOGGER.debug("RSASignature: being initialized for SHA512withRSAandMGF1");
        }
    }

    public static final class SHA384withRSAandMGF1
    extends RSASignature {
        public SHA384withRSAandMGF1() {
            super("SHA-384");
            this.setPssDigestAlgorithm("SHA-384");
            LOGGER.debug("RSASignature: being initialized for SHA384withRSAandMGF1");
        }
    }

    public static final class SHA256withRSAandMGF1
    extends RSASignature {
        public SHA256withRSAandMGF1() {
            super("SHA-256");
            this.setPssDigestAlgorithm("SHA-256");
            LOGGER.debug("RSASignature: being initialized for SHA256withRSAandMGF1");
        }
    }

    public static final class SHA1withRSAandMGF1
    extends RSASignature {
        public SHA1withRSAandMGF1() {
            super("SHA1");
            this.setPssDigestAlgorithm("SHA1");
            LOGGER.debug("RSASignature: being initialized for SHA1withRSAandMGF1");
        }
    }
}

