/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.util;

import com.fortanix.sdkms.v1.model.DigestAlgorithm;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;

public class ProviderUtil {
    public static String getSunAlgoForMessageDigest(DigestAlgorithm alg) {
        if (DigestAlgorithm.SHA1.equals(alg)) {
            return "SHA-1";
        }
        if (DigestAlgorithm.SHA256.equals(alg)) {
            return "SHA-256";
        }
        if (DigestAlgorithm.SHA384.equals(alg)) {
            return "SHA-384";
        }
        if (DigestAlgorithm.SHA512.equals(alg)) {
            return "SHA-512";
        }
        return "";
    }

    public static boolean isVersionGE(String serverVersion, String checkVersion) {
        if (serverVersion == null || checkVersion == null) {
            return false;
        }
        String[] serverVersions = serverVersion.split("\\.");
        if (serverVersions.length < 1 || serverVersions.length > 3) {
            return false;
        }
        String[] checkVersions = checkVersion.split("\\.");
        if (checkVersions.length < 1 || checkVersions.length > 3) {
            return false;
        }
        try {
            if (Integer.parseInt(serverVersions[0]) < Integer.parseInt(checkVersions[0])) {
                return false;
            }
            if (Integer.parseInt(serverVersions[0]) == Integer.parseInt(checkVersions[0]) && checkVersions.length >= 2) {
                if (serverVersions.length < 2 || Integer.parseInt(serverVersions[1]) < Integer.parseInt(checkVersions[1])) {
                    return false;
                }
                if (Integer.parseInt(serverVersions[1]) == Integer.parseInt(checkVersions[1]) && checkVersions.length == 3 && (serverVersions.length < 3 || Integer.parseInt(serverVersions[2]) < Integer.parseInt(checkVersions[2]))) {
                    return false;
                }
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String toStringSobjectDescriptor(SobjectDescriptor descriptor) {
        if (descriptor.getTransientKey() != null) {
            return "{ transientKey: true }";
        }
        if (descriptor.getName() != null) {
            return "{ name: " + descriptor.getName() + " }";
        }
        return "{ keyId: " + descriptor.getKid() + " }";
    }
}

