/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.valentino;

import com.fortanix.dsm.accelerator.DSMAccelerator;
import com.fortanix.dsm.accelerator.DSMAcceleratorException;
import com.fortanix.sdkms.jce.provider.config.Configuration;
import com.fortanix.sdkms.jce.provider.service.ISdkmsCommand;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.v1.ApiException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.LoggerFactory;

public class DSMAcceleratorClientSetup {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger((String)"SDKMS-API"));
    private static DSMAcceleratorClientSetup instance;
    private DSMAccelerator dsmAcceleratorClient;
    private static final List<Integer> invalidSessionCodes;
    private static final List<String> invalidSessionMessages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DSMAcceleratorClientSetup initialize() {
        if (instance != null) return instance;
        Class<DSMAcceleratorClientSetup> clazz = DSMAcceleratorClientSetup.class;
        synchronized (DSMAcceleratorClientSetup.class) {
            if (instance != null) return instance;
            instance = new DSMAcceleratorClientSetup();
            LOGGER.debug("Created instance of DSMAcceleratorClientSetup");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static DSMAcceleratorClientSetup getInstance() {
        if (instance == null) {
            return DSMAcceleratorClientSetup.initialize();
        }
        return instance;
    }

    private DSMAcceleratorClientSetup() {
        Configuration configuration = Configuration.getInstance();
        try {
            this.dsmAcceleratorClient = new DSMAccelerator(configuration.getSdkmsServerUrl());
        }
        catch (DSMAcceleratorException e) {
            LOGGER.logAndRaiseProviderException("Valentino client setup Failed", e);
        }
    }

    public void makeLoginRequest() {
        try {
            this.dsmAcceleratorClient.auth(Configuration.getInstance().getSdkmsApiKey());
        }
        catch (DSMAcceleratorException e) {
            LOGGER.logAndRaiseProviderException("Valentino authentication failed", e);
        }
    }

    public Object ensureValidSession(ISdkmsCommand command) throws ApiException {
        Object response = null;
        try {
            response = command.execute();
        }
        catch (ApiException apiException) {
            if (this.isSessionValid(apiException)) {
                throw apiException;
            }
            LOGGER.info("Session is expired. Trying re-login");
            this.makeLoginRequest();
            response = command.execute();
        }
        return response;
    }

    public boolean isSessionValid(ApiException apiException) {
        if (invalidSessionCodes.contains(apiException.getCode())) {
            return false;
        }
        return !invalidSessionMessages.stream().anyMatch(a -> apiException.getMessage().contains((CharSequence)a));
    }

    public void logout() {
        try {
            LOGGER.info("Session Termination");
            this.dsmAcceleratorClient.terminate();
        }
        catch (DSMAcceleratorException e) {
            LOGGER.info("Failure loggin gout the session: ", e);
        }
    }

    public DSMAccelerator getDsmAcceleratorClient() {
        return this.dsmAcceleratorClient;
    }

    public String getServerVersion() {
        return null;
    }

    static {
        invalidSessionCodes = Arrays.asList(401, 403);
        invalidSessionMessages = Arrays.asList("Session does not exist", "Session has expired");
    }
}

