/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.CipherCore;
import com.fortanix.sdkms.jce.provider.Configuration;
import com.fortanix.sdkms.jce.provider.SdkmsCipherKey;
import com.fortanix.sdkms.jce.provider.SdkmsJCE;
import com.fortanix.sdkms.jce.provider.SdkmsSecretKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.util.ProviderUtil;
import com.fortanix.sdkms.v1.model.CryptMode;
import com.fortanix.sdkms.v1.model.ObjectType;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.LoggerFactory;

public abstract class AESCipher
extends CipherSpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(AESCipher.class));
    private final CipherCore cipherCore;
    private final int expectedKeySize;

    protected AESCipher(int keySize, String mode, String padding, boolean isMultipartSupported) {
        this.expectedKeySize = keySize;
        boolean multipartMode = isMultipartSupported && !Configuration.getInstance().getCipherSinglePartOnly() && (!"GCM".equals(mode) || ProviderUtil.isVersionGE(SdkmsJCE.getInstance().getServerVersion(), "3.19"));
        this.cipherCore = multipartMode ? new CipherCore(ObjectType.AES, 16, CipherCore.CipherType.SUPPORTS_MULTIPART) : new CipherCore(ObjectType.AES, 16, CipherCore.CipherType.ONLY_SINGLE_PART);
        this.cipherCore.setCryptMode(CryptMode.fromValue((String)mode));
        this.cipherCore.setPadding(padding);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        LOGGER.debug("AESCipher: final");
        return this.cipherCore.doFinal(input, inputOffset, inputLen);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        LOGGER.debug("AESCipher: final");
        return this.cipherCore.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected byte[] engineGetIV() {
        return this.cipherCore.getIv();
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Only SecretKey is supported");
        }
        if (key instanceof SdkmsCipherKey) {
            return ((SdkmsCipherKey)((Object)key)).getKeySize();
        }
        throw new InvalidKeyException("Unsupported Key type. Only SdkmsCipherKey is supported");
    }

    @Override
    protected int engineGetOutputSize(int inputLength) {
        return this.cipherCore.getOutputSize(inputLength);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.cipherCore.getParameters("AES");
    }

    @Override
    protected void engineInit(int opMode, Key key, SecureRandom random) throws InvalidKeyException {
        LOGGER.debug("AESCipher: init");
        AESCipher.validateKey(key, this.expectedKeySize);
        this.cipherCore.init(opMode, key);
    }

    @Override
    protected void engineInit(int opMode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        LOGGER.debug("AESCipher: init");
        AESCipher.validateKey(key, this.expectedKeySize);
        this.cipherCore.init(opMode, key, params);
    }

    @Override
    protected void engineInit(int opMode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        LOGGER.debug("AESCipher: init");
        AESCipher.validateKey(key, this.expectedKeySize);
        this.cipherCore.init(opMode, key, params);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.cipherCore.setCryptMode(CryptMode.fromValue((String)mode));
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        this.cipherCore.setPadding(padding);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLength) {
        LOGGER.debug("AESCipher: update");
        if (input.length == 0) {
            return null;
        }
        return this.cipherCore.update(input, inputOffset, inputLength);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        LOGGER.debug("AESCipher: update");
        if (input.length == 0) {
            return 0;
        }
        return this.cipherCore.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) {
        LOGGER.debug("AESCipher: update AAD");
        this.cipherCore.updateAAD(src, offset, len);
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        LOGGER.debug("AESCipher: wrap key");
        return this.cipherCore.wrap(key);
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        LOGGER.debug("AESCipher: unwrap key");
        return this.cipherCore.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        byte[] aad;
        LOGGER.debug("AESCipher: update AAD");
        if (byteBuffer == null) {
            LOGGER.warn("AAD byteBuffer is null, hence cannot be updated");
            return;
        }
        int aadLength = byteBuffer.limit() - byteBuffer.position();
        if (aadLength <= 0) {
            LOGGER.warn("AAD byteBuffer is empty, hence cannot be updated");
            return;
        }
        int offset = 0;
        if (byteBuffer.hasArray()) {
            offset = byteBuffer.arrayOffset() + byteBuffer.position();
            aad = byteBuffer.array();
            byteBuffer.position(byteBuffer.limit());
        } else {
            aad = new byte[aadLength];
            byteBuffer.get(aad);
        }
        this.cipherCore.updateAAD(aad, offset, aadLength);
    }

    static void validateKey(Key key, int expectedKeySize) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (key instanceof SecretKeySpec) {
            return;
        }
        if (!(key instanceof SdkmsSecretKey)) {
            throw new InvalidKeyException("Unsupported Key type. Only SdkmsSecretKey is supported");
        }
        int actualKeySize = ((SdkmsSecretKey)key).getKeySize();
        if (actualKeySize != expectedKeySize) {
            throw new InvalidKeyException(String.format("Key Size- Expected: %d , Actual: %d", expectedKeySize, actualKeySize));
        }
    }

    public static final class Aes256CtrPKCS5Padding
    extends AESCipher {
        public Aes256CtrPKCS5Padding() {
            super(256, "CTR", "PKCS5PADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_256/CTR/PKCS5PADDING");
        }
    }

    public static final class Aes192CtrPKCS5Padding
    extends AESCipher {
        public Aes192CtrPKCS5Padding() {
            super(192, "CTR", "PKCS5PADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_192/CTR/PKCS5PADDING");
        }
    }

    public static final class Aes128CtrPKCS5Padding
    extends AESCipher {
        public Aes128CtrPKCS5Padding() {
            super(128, "CTR", "PKCS5PADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_128/CTR/PKCS5PADDING");
        }
    }

    public static final class Aes256GcmPKCS5Padding
    extends AESCipher {
        public Aes256GcmPKCS5Padding() {
            super(256, "GCM", "PKCS5PADDING", true);
            LOGGER.debug("AESCipher: being initialized for AES_256/GCM/PKCS5PADDING");
        }
    }

    public static final class Aes192GcmPKCS5Padding
    extends AESCipher {
        public Aes192GcmPKCS5Padding() {
            super(192, "GCM", "PKCS5PADDING", true);
            LOGGER.debug("AESCipher: being initialized for AES_192/GCM/PKCS5PADDING");
        }
    }

    public static final class Aes128GcmPKCS5Padding
    extends AESCipher {
        public Aes128GcmPKCS5Padding() {
            super(128, "GCM", "PKCS5PADDING", true);
            LOGGER.debug("AESCipher: being initialized for AES_128/GCM/PKCS5PADDING");
        }
    }

    public static final class Aes256CbcPKCS5Padding
    extends AESCipher {
        public Aes256CbcPKCS5Padding() {
            super(256, "CBC", "PKCS5PADDING", true);
            LOGGER.debug("AESCipher: being initialized for AES_256/CBC/PKCS5PADDING");
        }
    }

    public static final class Aes192CbcPKCS5Padding
    extends AESCipher {
        public Aes192CbcPKCS5Padding() {
            super(192, "CBC", "PKCS5PADDING", true);
            LOGGER.debug("AESCipher: being initialized for AES_192/CBC/PKCS5PADDING");
        }
    }

    public static final class Aes128CbcPKCS5Padding
    extends AESCipher {
        public Aes128CbcPKCS5Padding() {
            super(128, "CBC", "PKCS5PADDING", true);
            LOGGER.debug("AESCipher: being initialized for AES_128/CBC/PKCS5PADDING");
        }
    }

    public static final class Aes256CbcNOPadding
    extends AESCipher {
        public Aes256CbcNOPadding() {
            super(256, "CBC", "NOPADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_256/CBC/NoPadding");
        }
    }

    public static final class Aes192CbcNOPadding
    extends AESCipher {
        public Aes192CbcNOPadding() {
            super(192, "CBC", "NOPADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_192/CBC/NoPadding");
        }
    }

    public static final class Aes128CbcNOPadding
    extends AESCipher {
        public Aes128CbcNOPadding() {
            super(128, "CBC", "NOPADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_128/CBC/NoPadding");
        }
    }

    public static final class Aes256CcmPKCS5Padding
    extends AESCipher {
        public Aes256CcmPKCS5Padding() {
            super(256, "CCM", "PKCS5PADDING", false);
        }
    }

    public static final class Aes192CcmPKCS5Padding
    extends AESCipher {
        public Aes192CcmPKCS5Padding() {
            super(192, "CCM", "PKCS5PADDING", false);
        }
    }

    public static final class Aes128CcmPKCS5Padding
    extends AESCipher {
        public Aes128CcmPKCS5Padding() {
            super(128, "CCM", "PKCS5PADDING", false);
        }
    }

    public static final class Aes256CfbPKCS5Padding
    extends AESCipher {
        public Aes256CfbPKCS5Padding() {
            super(256, "CFB", "PKCS5PADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_256/CFB/PKCS5PADDING");
        }
    }

    public static final class Aes192CfbPKCS5Padding
    extends AESCipher {
        public Aes192CfbPKCS5Padding() {
            super(192, "CFB", "PKCS5PADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_192/CFB/PKCS5PADDING");
        }
    }

    public static final class Aes128CfbPKCS5Padding
    extends AESCipher {
        public Aes128CfbPKCS5Padding() {
            super(128, "CFB", "PKCS5PADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_128/CFB/PKCS5PADDING");
        }
    }

    public static final class Aes256EcbPKCS5Padding
    extends AESCipher {
        public Aes256EcbPKCS5Padding() {
            super(256, "ECB", "PKCS5PADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_256/ECB/PKCS5PADDING");
        }
    }

    public static final class Aes192EcbPKCS5Padding
    extends AESCipher {
        public Aes192EcbPKCS5Padding() {
            super(192, "ECB", "PKCS5PADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_192/ECB/PKCS5PADDING");
        }
    }

    public static final class Aes128EcbPKCS5Padding
    extends AESCipher {
        public Aes128EcbPKCS5Padding() {
            super(128, "ECB", "PKCS5PADDING", false);
            LOGGER.debug("AESCipher: being initialized for AES_128/ECB/PKCS5PADDING");
        }
    }
}

