/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.SdkmsKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.jce.provider.util.ProviderUtil;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.slf4j.LoggerFactory;
import sun.security.pkcs.PKCS8Key;

public class DSAPrivateKeyImpl
extends PKCS8Key
implements DSAPrivateKey,
SdkmsKey {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(DSAPrivateKey.class));
    private SobjectDescriptor descriptor;
    private Boolean isExportable;
    private byte[] encoded;

    public DSAPrivateKeyImpl(KeyObject keyObject) {
        this.descriptor = SdkmsKeyService.getKeyDescriptor(keyObject);
        this.initFromKeyObject(keyObject);
    }

    private void initFromKeyObject(KeyObject keyObject) {
        this.isExportable = keyObject.getKeyOps() != null && keyObject.getKeyOps().contains(KeyOperations.EXPORT);
    }

    @Override
    public SobjectDescriptor getKeyDescriptor() {
        return this.descriptor;
    }

    @Override
    public BigInteger getX() {
        return null;
    }

    @Override
    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)((Object)this.algid);
            }
            AlgorithmParameters var2 = this.algid.getParameters();
            if (var2 == null) {
                return null;
            }
            DSAParameterSpec var1 = var2.getParameterSpec(DSAParameterSpec.class);
            return var1;
        }
        catch (InvalidParameterSpecException var3) {
            return null;
        }
    }

    @Override
    public byte[] getEncoded() {
        if (this.isExportable.booleanValue()) {
            if (this.encoded == null) {
                this.encoded = SdkmsKeyService.getKeyValue(this.descriptor);
            }
        } else {
            LOGGER.info("Trying to get key material of a non exportable key: " + ProviderUtil.toStringSobjectDescriptor(this.descriptor));
        }
        return this.encoded;
    }
}

