/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.Configuration;
import com.fortanix.sdkms.jce.provider.DSAPrivateKeyImpl;
import com.fortanix.sdkms.jce.provider.DSAPublicKeyImpl;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsSignature;
import com.fortanix.sdkms.jce.provider.util.ProviderUtil;
import com.fortanix.sdkms.v1.model.SignResponse;
import com.fortanix.sdkms.v1.model.VerifyResponse;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import org.slf4j.LoggerFactory;

public class DSASignature
extends SignatureSpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(DSASignature.class));
    private MessageDigest md = null;
    private ProviderUtil.DigestAlgorithms digestAlgorithm;
    private DSAPublicKeyImpl publicKey;
    private DSAPrivateKeyImpl privateKey;
    private boolean digestReset;

    DSASignature(String digestAlgorithm) {
        LOGGER.debug("Initializing DSA Signature");
        this.digestAlgorithm = ProviderUtil.DigestAlgorithms.getByKey(digestAlgorithm);
        if (this.digestAlgorithm == null) {
            throw new ProviderException("The digest algorithm " + digestAlgorithm + " is not supported");
        }
        try {
            this.md = MessageDigest.getInstance(digestAlgorithm, Configuration.getInstance().getProviderName());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOGGER.logAndRaiseProviderException("Failed to initialize DSA Signature", e);
        }
        this.digestReset = true;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        LOGGER.debug("DSA Signature: verify init");
        if (!(publicKey instanceof DSAPublicKeyImpl)) {
            throw new InvalidKeyException("Key is not of type DSAPublicImpl");
        }
        this.privateKey = null;
        this.publicKey = (DSAPublicKeyImpl)publicKey;
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        LOGGER.debug("DSASignature: sign init");
        if (!(privateKey instanceof DSAPrivateKeyImpl)) {
            throw new InvalidKeyException("Only DSAPrivateKeyImpl is supported");
        }
        this.privateKey = (DSAPrivateKeyImpl)privateKey;
        this.publicKey = null;
        this.resetDigest();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        LOGGER.debug("DSA Signature: sign update");
        this.md.update(b);
        this.digestReset = false;
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        LOGGER.debug("DSA Signature: sign update");
        this.md.update(b, off, len);
        this.digestReset = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        LOGGER.debug("DSA Signature: sign final");
        byte[] digest = this.getDigestValue();
        SignResponse signResponse = SdkmsSignature.signDigest(digest, this.digestAlgorithm.getValue(), this.privateKey.getKeyDescriptor(), null);
        return signResponse.getSignature();
    }

    @Override
    protected boolean engineVerify(byte[] bytes) throws SignatureException {
        LOGGER.debug("DSA Signature: verify final");
        byte[] digest = this.getDigestValue();
        VerifyResponse verifyResponse = SdkmsSignature.verifyDigest(bytes, digest, this.digestAlgorithm.getValue(), this.publicKey.getKeyDescriptor(), null);
        return verifyResponse.getResult();
    }

    @Override
    protected void engineSetParameter(String s, Object o) throws InvalidParameterException {
        LOGGER.logAndRaiseProviderException("method setParameter() not supported", null);
    }

    @Override
    protected Object engineGetParameter(String s) throws InvalidParameterException {
        LOGGER.logAndRaiseProviderException("method getParameter() not supported", null);
        return null;
    }

    private byte[] getDigestValue() {
        this.digestReset = true;
        return this.md.digest();
    }

    private void resetDigest() {
        if (!this.digestReset) {
            this.md.reset();
            this.digestReset = true;
        }
    }

    public static final class SHA512withDSA
    extends DSASignature {
        public SHA512withDSA() {
            super("SHA-512");
            LOGGER.debug("DSASignature: being initialized for SHA512withDSA");
        }
    }

    public static final class SHA384withDSA
    extends DSASignature {
        public SHA384withDSA() {
            super("SHA-384");
            LOGGER.debug("DSASignature: being initialized for SHA384withDSA");
        }
    }

    public static final class SHA256withDSA
    extends DSASignature {
        public SHA256withDSA() {
            super("SHA-256");
            LOGGER.debug("DSASignature: being initialized for SHA256withDSA");
        }
    }

    public static final class SHA1withDSA
    extends DSASignature {
        public SHA1withDSA() {
            super("SHA1");
            LOGGER.debug("DSASignature: being initialized for SHA1withDSA");
        }
    }
}

