/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.SdkmsKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.jce.provider.util.ProviderUtil;
import com.fortanix.sdkms.v1.model.AgreeKeyMechanism;
import com.fortanix.sdkms.v1.model.AgreeKeyRequest;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.UUID;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.LoggerFactory;

public class ECDHKeyAgreement
extends KeyAgreementSpi {
    private String privateKeyId;
    private String publicKeyId;
    private String sharedKeyId;
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(ECDHKeyAgreement.class));

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        LOGGER.debug("ECDHKeyAgreement: perform key agreement");
        if (this.privateKeyId == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicKeyId != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
        }
        KeyObject publicKeyObject = SdkmsKeyService.toKeyObject(key);
        this.publicKeyId = publicKeyObject.getKid();
        String securityObjectName = UUID.randomUUID().toString();
        AgreeKeyRequest agreeKeyRequest = new AgreeKeyRequest();
        agreeKeyRequest.setPrivateKey(new SobjectDescriptor().kid(this.privateKeyId));
        agreeKeyRequest.setPublicKey(new SobjectDescriptor().kid(this.publicKeyId));
        agreeKeyRequest.mechanism(AgreeKeyMechanism.HELLMAN).keyType(ObjectType.SECRET).enabled(Boolean.valueOf(true)).keySize(Integer.valueOf(ProviderUtil.ECKeySizeSpec.getByKey(publicKeyObject.getEllipticCurve().toString()).getValue())).name(securityObjectName);
        KeyObject keyObject = SdkmsKeyService.agreeKey(agreeKeyRequest);
        this.sharedKeyId = keyObject.getKid();
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        LOGGER.debug("ECDHKeyAgreement: generate shared secret");
        if (this.privateKeyId == null || this.publicKeyId == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        byte[] keyValue = SdkmsKeyService.getKeyValue(this.sharedKeyId);
        if (keyValue == null) {
            LOGGER.logAndRaiseProviderException("Failed to fetch secret value of the shared key: " + this.sharedKeyId, null);
        }
        return keyValue;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        LOGGER.debug("ECDHKeyAgreement: generate shared secret");
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), algorithm);
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        LOGGER.debug("ECDHKeyAgreement: generate shared secret");
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, sharedSecret, 0, secret.length);
        return secret.length;
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        LOGGER.debug("ECDHKeyAgreement: init with given key");
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        this.privateKeyId = ((SdkmsKey)((Object)key)).getKeyDescriptor().getKid();
        this.publicKeyId = null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        LOGGER.debug("ECDHKeyAgreement: init with given key and params");
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, random);
    }
}

