/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.ECPrivateKeyImpl;
import com.fortanix.sdkms.jce.provider.ECPublicKeyImpl;
import com.fortanix.sdkms.jce.provider.SecurityObjectKeySpec;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdKmsEc;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import org.slf4j.LoggerFactory;

public class ECKeyFactory
extends KeyFactorySpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(ECKeyFactory.class));
    private List<KeyOperations> allowedKeyOperations;
    private String alias;

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        LOGGER.debug("ECKeyFactory: import public key using keyspec");
        if (!(keySpec instanceof X509EncodedKeySpec) && !(keySpec instanceof SecurityObjectKeySpec)) {
            LOGGER.logAndRaiseProviderException("Invalid Spec for generating Public Key. Only X509EncodedKeySpec and SecurityObjectKeySpec are supported.", null);
        }
        if (keySpec instanceof SecurityObjectKeySpec) {
            this.allowedKeyOperations = ((SecurityObjectKeySpec)keySpec).getAllowedKeyOperations();
            this.alias = ((SecurityObjectKeySpec)keySpec).getAlias();
            keySpec = ((SecurityObjectKeySpec)keySpec).getKeySpec();
        }
        try {
            KeyObject keyObject = SdKmsEc.importKeyForEcOperation(this.allowedKeyOperations, ((X509EncodedKeySpec)keySpec).getEncoded(), this.alias);
            return new ECPublicKeyImpl(keyObject);
        }
        catch (IllegalArgumentException e) {
            LOGGER.logAndRaiseProviderException("Unsupported curve specified in keySpec", e);
            return null;
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        LOGGER.debug("ECKeyFactory: import private key using keyspec");
        if (!(keySpec instanceof PKCS8EncodedKeySpec) && !(keySpec instanceof SecurityObjectKeySpec)) {
            LOGGER.logAndRaiseProviderException("Invalid Spec for generating Public Key. Only PKCS8EncodedKeySpec and SecurityObjectKeySpec are supported.", null);
        }
        if (keySpec instanceof SecurityObjectKeySpec) {
            this.allowedKeyOperations = ((SecurityObjectKeySpec)keySpec).getAllowedKeyOperations();
            this.alias = ((SecurityObjectKeySpec)keySpec).getAlias();
            keySpec = ((SecurityObjectKeySpec)keySpec).getKeySpec();
        }
        KeyObject keyObject = SdKmsEc.importKeyForEcOperation(this.allowedKeyOperations, ((PKCS8EncodedKeySpec)keySpec).getEncoded(), this.alias);
        return new ECPrivateKeyImpl(keyObject);
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        LOGGER.debug("ECKeyFactory: get keyspec");
        if (key instanceof ECPublicKey) {
            if (X509EncodedKeySpec.class.isAssignableFrom(keySpec)) {
                return (T)((KeySpec)keySpec.cast(new X509EncodedKeySpec(key.getEncoded())));
            }
            throw new InvalidKeySpecException("KeySpec must be X509EncodedKeySpec for EC public keys");
        }
        if (key instanceof ECPrivateKey) {
            if (PKCS8EncodedKeySpec.class.isAssignableFrom(keySpec)) {
                return (T)((KeySpec)keySpec.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
            }
            throw new InvalidKeySpecException("KeySpec must be PKCS8EncodedKeySpec for EC private keys");
        }
        return null;
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        LOGGER.debug("ECKeyFactory: translate key");
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        String keyAlg = key.getAlgorithm();
        if (!keyAlg.equals("EC")) {
            throw new InvalidKeyException("Not an EC key: " + keyAlg);
        }
        if (key instanceof PublicKey) {
            return this.implTranslatePublicKey((PublicKey)key);
        }
        if (key instanceof PrivateKey) {
            return this.implTranslatePrivateKey((PrivateKey)key);
        }
        throw new InvalidKeyException("Neither a public nor a private key");
    }

    private PublicKey implTranslatePublicKey(PublicKey key) throws InvalidKeyException {
        if ("X.509".equals(key.getFormat())) {
            try {
                return this.engineGeneratePublic(this.engineGetKeySpec(key, X509EncodedKeySpec.class));
            }
            catch (InvalidKeySpecException e) {
                LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            }
        } else {
            throw new InvalidKeyException("Public keys must have X.509 encoding");
        }
        return null;
    }

    private PrivateKey implTranslatePrivateKey(PrivateKey key) throws InvalidKeyException {
        if ("PKCS#8".equals(key.getFormat())) {
            try {
                return this.engineGeneratePrivate(this.engineGetKeySpec(key, PKCS8EncodedKeySpec.class));
            }
            catch (InvalidKeySpecException e) {
                LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            }
        } else {
            throw new InvalidKeyException("Private keys must have PKCS#8 encoding");
        }
        return null;
    }

    private String parseCurveNameForSdkms(String curvename) {
        curvename = curvename.replaceAll("\\s*\\[[^\\)]*\\]\\s*", "");
        curvename = curvename.replaceAll("\\s*\\([^\\)]*\\)\\s*", "");
        curvename = curvename.replaceAll("\\s+", "");
        return curvename;
    }
}

