/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.ECPrivateKeyImpl;
import com.fortanix.sdkms.jce.provider.ECPublicKeyImpl;
import com.fortanix.sdkms.jce.provider.SecurityObjectParameterSpec;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdKmsEc;
import com.fortanix.sdkms.jce.provider.util.ProviderUtil;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.List;
import org.slf4j.LoggerFactory;

public class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private ECGenParameterSpec params;
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(ECKeyPairGenerator.class));
    private List<KeyOperations> allowedKeyOperations;
    private boolean isTransientKey = true;

    @Override
    public void initialize(int keySize, SecureRandom random) {
        LOGGER.logAndRaiseProviderException("Cannot initialize EC Key Generator using key size. Use AlgorithmParamSpec instead.", null);
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        LOGGER.debug("EC KeyPair Generator: init using params");
        if (params instanceof SecurityObjectParameterSpec) {
            this.allowedKeyOperations = ((SecurityObjectParameterSpec)params).getAllowedKeyOperations();
            this.isTransientKey = ((SecurityObjectParameterSpec)params).getIsTransientKey();
            params = ((SecurityObjectParameterSpec)params).getParamSpec();
        }
        this.params = (ECGenParameterSpec)params;
    }

    public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.initialize(params, null);
    }

    @Override
    public KeyPair generateKeyPair() {
        LOGGER.debug("EC KeyPair generate");
        KeyObject keyObject = SdKmsEc.generateKeyForEcOperation(ProviderUtil.ECGenSpec.getByKey(this.params.getName()).getValue(), this.allowedKeyOperations, this.isTransientKey);
        ECPublicKeyImpl ecPublicKey = new ECPublicKeyImpl(keyObject);
        ECPrivateKeyImpl ecPrivateKey = new ECPrivateKeyImpl(keyObject);
        return new KeyPair(ecPublicKey, ecPrivateKey);
    }
}

