/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.SdkmsHmacKey;
import com.fortanix.sdkms.jce.provider.SdkmsKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsMac;
import com.fortanix.sdkms.v1.model.DigestAlgorithm;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import org.slf4j.LoggerFactory;

public class HmacCore
extends MacSpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(HmacCore.class));
    private ByteArrayOutputStream accumulatedBytes = new ByteArrayOutputStream();
    private int size;
    private DigestAlgorithm algorithm;
    private SobjectDescriptor sobjectDescriptor;

    public HmacCore(DigestAlgorithm algorithm, int size) {
        this.algorithm = algorithm;
        this.size = size;
    }

    @Override
    protected byte[] engineDoFinal() {
        LOGGER.debug("HMAC: final");
        byte[] hamc = SdkmsMac.computeMac(this.sobjectDescriptor, this.algorithm, this.accumulatedBytes.toByteArray());
        this.engineReset();
        return hamc;
    }

    @Override
    protected int engineGetMacLength() {
        LOGGER.debug("HMAC: get length");
        return this.size / 8;
    }

    @Override
    protected void engineInit(Key secretKey, AlgorithmParameterSpec arg1) throws InvalidKeyException, InvalidAlgorithmParameterException {
        LOGGER.debug("HMAC: init");
        if (!(secretKey instanceof SdkmsHmacKey)) {
            throw new InvalidKeyException("SdkmsMacKey expected");
        }
        this.sobjectDescriptor = ((SdkmsKey)((Object)secretKey)).getKeyDescriptor();
    }

    @Override
    protected void engineReset() {
        LOGGER.debug("HMAC: reset");
        this.accumulatedBytes.reset();
    }

    @Override
    protected void engineUpdate(byte b) {
        LOGGER.debug("HMAC: update");
        this.accumulatedBytes.write(b);
    }

    @Override
    protected void engineUpdate(byte[] bytes, int offset, int length) {
        LOGGER.debug("HMAC: update");
        this.accumulatedBytes.write(bytes, offset, length);
    }

    public static final class HmacRIPEMD160
    extends HmacCore {
        public HmacRIPEMD160() {
            super(DigestAlgorithm.RIPEMD160, 512);
            LOGGER.debug("Hmac: being initialized for HmacSHA512");
        }
    }

    public static final class HmacSHA512
    extends HmacCore {
        public HmacSHA512() {
            super(DigestAlgorithm.SHA512, 512);
            LOGGER.debug("Hmac: being initialized for HmacSHA512");
        }
    }

    public static final class HmacSHA384
    extends HmacCore {
        public HmacSHA384() {
            super(DigestAlgorithm.SHA384, 384);
            LOGGER.debug("Hmac: being initialized for HmacSHA384");
        }
    }

    public static final class HmacSHA256
    extends HmacCore {
        public HmacSHA256() {
            super(DigestAlgorithm.SHA256, 256);
            LOGGER.debug("Hmac: being initialized for HmacSHA256");
        }
    }

    public static final class HmacSHA160
    extends HmacCore {
        public HmacSHA160() {
            super(DigestAlgorithm.SHA1, 160);
            LOGGER.debug("Hmac: being initialized for HmacSHA1");
        }
    }
}

