/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fortanix.sdkms.jce.provider.Configuration;
import com.fortanix.sdkms.jce.provider.KeyStore;
import com.fortanix.sdkms.jce.provider.SdkmsKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCertificate;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.v1.model.KeyObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.LoggerFactory;

public final class LocalKeyStore
extends KeyStore {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(LocalKeyStore.class));
    @Deprecated
    private final Hashtable<String, Object> deprecated_store = new Hashtable();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final HashMap<String, KeyStoreEntry> store = new HashMap();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        LOGGER.debug("Get key " + alias + " from keystore");
        KeyStoreEntry entry = this.store.get(alias);
        if (entry == null || entry.keyName.isEmpty()) {
            LOGGER.debug("key " + alias + " not found from keystore");
            return null;
        }
        try {
            KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(entry.keyName);
            if (keyObject == null) {
                LOGGER.debug("key " + alias + " not found in SDKMS");
                return null;
            }
            return SdkmsKeyService.getKeyFromKeyObject(keyObject, false);
        }
        catch (InvalidKeyException e) {
            LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        LOGGER.debug("Get certificate chain " + alias + " from keystore");
        KeyStoreEntry entry = this.store.get(alias);
        if (entry == null) {
            LOGGER.debug("certificate chain " + alias + " not found from keystore");
            return null;
        }
        int chainLength = entry.chain == null ? 0 : entry.chain.length;
        Certificate[] chain = new Certificate[chainLength];
        for (int i = 0; i < chainLength; ++i) {
            try {
                KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(entry.chain[i]);
                if (keyObject == null) continue;
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "SUN");
                chain[i] = certFactory.generateCertificate(new ByteArrayInputStream(keyObject.getValue()));
                continue;
            }
            catch (NoSuchProviderException | CertificateException e) {
                LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            }
        }
        return chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        LOGGER.debug("Get certificate " + alias + " from keystore");
        KeyStoreEntry entry = this.store.get(alias);
        if (entry == null) {
            LOGGER.debug("certificate " + alias + " not found from keystore");
            return null;
        }
        String keyId = null;
        if (entry.isCertEntry) {
            keyId = entry.certId;
        } else if (entry.chain != null && entry.chain.length > 0) {
            keyId = entry.chain[0];
        }
        if (keyId == null) {
            return null;
        }
        return super.engineGetCertificate(keyId);
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        LOGGER.debug("Get key " + alias + " creation date from keystore");
        return this.store.get((Object)alias).date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        LOGGER.debug("Adding key " + alias + " to keystore");
        HashMap<String, KeyStoreEntry> hashMap = this.store;
        synchronized (hashMap) {
            if (key instanceof PrivateKey) {
                this.setPrivateKeyEntry(alias, key, chain);
            } else {
                this.setSecretKeyEntry(alias, key);
            }
        }
    }

    private void setPrivateKeyEntry(String alias, Key key, Certificate[] chain) {
        KeyStoreEntry entry = new KeyStoreEntry();
        entry.date = new Date();
        entry.keyName = alias + this.getRandomString();
        if (!(key instanceof SdkmsKey)) {
            this.importPrivateKey(key, entry);
        } else if (((SdkmsKey)((Object)key)).getKeyDescriptor().getTransientKey() != null) {
            SdkmsKeyService.persistKey(key, entry.keyName, null);
        } else {
            SdkmsKeyService.updateKey(((SdkmsKey)((Object)key)).getKeyDescriptor(), entry.keyName, null);
        }
        if (chain != null) {
            String[] chainId = new String[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                String certificateObjectName = entry.keyName + "-certificate-" + i;
                SdkmsCertificate.importCertificate(chain[i], certificateObjectName, null);
                chainId[i] = certificateObjectName;
            }
            entry.chain = chainId;
        }
        this.store.put(alias, entry);
    }

    private void setSecretKeyEntry(String alias, Key key) {
        KeyStoreEntry entry = new KeyStoreEntry();
        entry.date = new Date();
        entry.keyName = alias + this.getRandomString();
        if (!(key instanceof SdkmsKey)) {
            this.importSecretKey(key, entry);
        } else if (((SdkmsKey)((Object)key)).getKeyDescriptor().getTransientKey() != null) {
            SdkmsKeyService.persistKey(key, entry.keyName, null);
        } else {
            SdkmsKeyService.updateKey(((SdkmsKey)((Object)key)).getKeyDescriptor(), entry.keyName, null);
        }
        this.store.put(alias, entry);
    }

    private void importPrivateKey(Key key, KeyStoreEntry entry) {
        LOGGER.debug("Importing key into SDKMS");
        try {
            KeyFactory factory = KeyFactory.getInstance(key.getAlgorithm(), Configuration.getInstance().getProviderName());
            PrivateKey generatedKey = factory.generatePrivate(new PKCS8EncodedKeySpec(key.getEncoded()));
            SdkmsKeyService.updateKey(((SdkmsKey)((Object)generatedKey)).getKeyDescriptor(), entry.keyName, null);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            LOGGER.logAndRaiseProviderException("Failed to import private key ", e);
        }
    }

    private void importSecretKey(Key key, KeyStoreEntry entry) {
        LOGGER.debug("Importing key into keystore");
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(key.getAlgorithm(), Configuration.getInstance().getProviderName());
            SecretKey generatedKey = factory.generateSecret(new SecretKeySpec(key.getEncoded(), key.getAlgorithm()));
            SdkmsKeyService.updateKey(((SdkmsKey)((Object)generatedKey)).getKeyDescriptor(), entry.keyName, null);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            LOGGER.logAndRaiseProviderException("Failed to import secret key", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) {
        LOGGER.debug("Adding certificate " + alias + " to keystore");
        HashMap<String, KeyStoreEntry> hashMap = this.store;
        synchronized (hashMap) {
            try {
                KeyStoreEntry entry = new KeyStoreEntry();
                String certificateObjectName = alias + this.getRandomString() + "-certificate";
                super.setCertificateEntry(certificateObjectName, cert, null);
                entry.certId = certificateObjectName;
                entry.date = new Date();
                entry.isCertEntry = true;
                this.store.put(alias, entry);
            }
            catch (KeyStoreException e) {
                LOGGER.logAndRaiseProviderException("Failed to add certificate to keystore", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        LOGGER.debug("Deleting entry " + alias + " from keystore");
        HashMap<String, KeyStoreEntry> hashMap = this.store;
        synchronized (hashMap) {
            KeyStoreEntry entry = this.store.get(alias);
            if (!entry.isCertEntry) {
                KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(entry.keyName);
                if (keyObject != null) {
                    SdkmsKeyService.deleteKey(keyObject.getKid());
                }
                if (entry.chain != null) {
                    int failureCount = 0;
                    for (int i = 0; i < entry.chain.length; ++i) {
                        keyObject = SdkmsKeyService.getSecurityObjectByName(entry.chain[i]);
                        if (keyObject == null) continue;
                        try {
                            SdkmsKeyService.deleteKey(keyObject.getKid());
                            continue;
                        }
                        catch (Exception e) {
                            ++failureCount;
                            LOGGER.warn("Ignoring certificate deletion failure in SDKMS: " + entry.chain[i], e);
                        }
                    }
                    if (failureCount > 0) {
                        LOGGER.logAndRaiseProviderException("Failed to delete certificate chain", null);
                    }
                }
            } else {
                KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(entry.certId);
                if (keyObject != null) {
                    SdkmsKeyService.deleteKey(keyObject.getKid());
                }
            }
            this.store.remove(alias);
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        LOGGER.debug("Get All aliases from keystore");
        return Collections.enumeration(this.store.keySet());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        LOGGER.debug("Contains check for alias " + alias + " in keystore");
        return this.store.containsKey(alias);
    }

    @Override
    public int engineSize() {
        LOGGER.debug("Get keystore size");
        return this.store.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        LOGGER.debug("Is key entry check for alias " + alias + " in keystore");
        KeyStoreEntry entry = this.store.get(alias);
        if (entry == null) {
            return false;
        }
        return !entry.isCertEntry;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        LOGGER.debug("Is certificate entry check for alias " + alias + " in keystore");
        KeyStoreEntry entry = this.store.get(alias);
        if (entry == null) {
            return false;
        }
        return entry.isCertEntry;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        LOGGER.debug("Get alias for certificate in keystore");
        String certElem = null;
        for (String alias : this.store.keySet()) {
            KeyStoreEntry entry = this.store.get(alias);
            if (entry.isCertEntry) {
                certElem = entry.certId;
            } else {
                if (entry.chain == null || entry.chain.length <= 0) continue;
                certElem = entry.chain[0];
            }
            try {
                if (certElem.isEmpty()) continue;
                KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(certElem);
                if (!new String(cert.getEncoded()).equalsIgnoreCase(new String(keyObject.getValue()))) continue;
                return alias;
            }
            catch (CertificateEncodingException exp) {
                LOGGER.logAndRaiseProviderException("Failed to get alias for certificate", exp);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException {
        LOGGER.debug("Saving keystore");
        if (stream == null) {
            throw new ProviderException("Invalid output stream");
        }
        HashMap<String, KeyStoreEntry> hashMap = this.store;
        synchronized (hashMap) {
            OBJECT_MAPPER.writeValue(stream, this.store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        LOGGER.debug("Loading keystore");
        if (stream == null) {
            return;
        }
        ByteArrayOutputStream outputStream = this.copyInputStream(stream);
        stream = new ByteArrayInputStream(outputStream.toByteArray());
        HashMap<String, KeyStoreEntry> hashMap = this.store;
        synchronized (hashMap) {
            try {
                ObjectInputStream in = new ObjectInputStream(stream);
                Hashtable input = (Hashtable)in.readObject();
                in.close();
                Enumeration e = input.keys();
                while (e.hasMoreElements()) {
                    String alias = (String)e.nextElement();
                    this.store.put(alias, this.objectToKeyStoreEntry(input.get(alias)));
                }
                return;
            }
            catch (StreamCorruptedException e) {
                stream.close();
            }
            catch (ClassNotFoundException e) {
                stream.close();
                LOGGER.logAndRaiseProviderException("Failed to load keystore", e);
            }
            try {
                this.store.putAll((Map)OBJECT_MAPPER.readValue(outputStream.toByteArray(), (TypeReference)new TypeReference<Map<String, KeyStoreEntry>>(){}));
            }
            catch (Exception e) {
                LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            }
        }
    }

    private ByteArrayOutputStream copyInputStream(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        in.close();
        return baos;
    }

    private String getRandomString() {
        byte[] b = new byte[6];
        new Random().nextBytes(b);
        return " (" + DatatypeConverter.printHexBinary((byte[])b) + ")";
    }

    private KeyStoreEntry objectToKeyStoreEntry(Object object) {
        KeyStoreEntry entry = new KeyStoreEntry();
        if (object instanceof TrustedCertEntry) {
            entry.isCertEntry = true;
            entry.certId = ((TrustedCertEntry)object).certId;
            entry.date = ((TrustedCertEntry)object).date;
            return entry;
        }
        if (object instanceof PrivateKeyEntry) {
            entry.chain = ((PrivateKeyEntry)object).chain;
        }
        entry.keyName = ((KeyEntry)object).name;
        entry.date = ((KeyEntry)object).date;
        return entry;
    }

    private static class KeyStoreEntry {
        public String keyName;
        public Date date;
        public String[] chain;
        public String certId;
        public boolean isCertEntry = false;

        private KeyStoreEntry() {
        }
    }

    @Deprecated
    private static class KeyEntry
    implements Serializable {
        private static final long serialVersionUID = -5142363665585798533L;
        String name;
        Date date;

        private KeyEntry() {
        }
    }

    @Deprecated
    private static class TrustedCertEntry
    implements Serializable {
        private static final long serialVersionUID = 3753936163205389700L;
        Date date;
        String certId;

        private TrustedCertEntry() {
        }
    }

    @Deprecated
    private static class PrivateKeyEntry
    extends KeyEntry
    implements Serializable {
        private static final long serialVersionUID = -6193851493258721062L;
        String[] chain;

        private PrivateKeyEntry() {
        }
    }
}

