/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.IPadding;
import java.io.ByteArrayOutputStream;

public class NoPadding
implements IPadding {
    private int blockSize;

    public NoPadding(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public void pad(ByteArrayOutputStream in) {
        int padLength = this.getPaddingLength(in.toByteArray().length);
        int paddingOctet = 0;
        for (int i = 0; i < padLength; ++i) {
            in.write(paddingOctet);
        }
    }

    @Override
    public byte[] unpad(byte[] in) {
        int start = 0;
        byte lastByte = in[in.length - 1];
        if (lastByte != 0) {
            return in;
        }
        for (int i = in.length - 1; i > 0; --i) {
            if (in[i] == lastByte) continue;
            start = i + 1;
            break;
        }
        byte[] output = new byte[start];
        System.arraycopy(in, 0, output, 0, start);
        return output;
    }

    @Override
    public String getName() {
        return "NOPADDING";
    }

    @Override
    public int getPaddingLength(int inputLength) {
        return this.blockSize - inputLength % this.blockSize;
    }
}

