/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.CipherCore;
import com.fortanix.sdkms.jce.provider.SdkmsCipherKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.v1.model.CryptMode;
import com.fortanix.sdkms.v1.model.ObjectType;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.slf4j.LoggerFactory;

public abstract class RSACipher
extends CipherSpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(RSACipher.class));
    private final CipherCore cipherCore = new CipherCore(ObjectType.RSA, 0, CipherCore.CipherType.ONLY_SINGLE_PART);

    public RSACipher() {
        this.cipherCore.setPadding("PKCS5PADDING");
    }

    public RSACipher(String mode) {
        this();
        this.cipherCore.setCryptMode(CryptMode.fromValue((String)mode));
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        LOGGER.debug("RSA Cipher final");
        return this.cipherCore.doFinal(input, inputOffset, inputLen);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        LOGGER.debug("RSA Cipher final");
        return this.cipherCore.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected int engineGetBlockSize() {
        return this.cipherCore.getBlockSize();
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.cipherCore.getBlockSize();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        LOGGER.debug("RSA Cipher init");
        this.cipherCore.init(opmode, key);
        this.cipherCore.setBlockSize(this.determineBlockSize(this.cipherCore.getKey().getKeySize()));
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, null);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, null);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.cipherCore.setCryptMode(CryptMode.fromValue((String)mode));
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!Arrays.asList("PKCS5PADDING", "OAEPPADDING").contains(padding.toUpperCase())) {
            throw new NoSuchPaddingException("Padding " + padding + " not supported");
        }
        this.cipherCore.setPadding(padding);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        LOGGER.debug("RSA Cipher update");
        return this.cipherCore.update(input, inputOffset, inputLen);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        LOGGER.debug("RSA Cipher update");
        return this.cipherCore.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected byte[] engineWrap(Key keyToWrap) throws IllegalBlockSizeException, InvalidKeyException {
        LOGGER.debug("RSA Cipher: wrap key");
        return this.cipherCore.wrap(keyToWrap);
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        LOGGER.debug("RSA Cipher: unwrap key");
        return this.cipherCore.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof PrivateKey) && !(key instanceof PublicKey)) {
            throw new InvalidKeyException("Only PrivateKey and PublicKey are supported");
        }
        if (key instanceof SdkmsCipherKey) {
            return ((SdkmsCipherKey)((Object)key)).getKeySize();
        }
        throw new InvalidKeyException("Unsupported Key type. Only SdkmsCipherKey is supported");
    }

    private int determineBlockSize(Integer rsaKeySizeInBits) {
        return rsaKeySizeInBits / 8;
    }

    public static final class RSAPKCSV15
    extends RSACipher {
        public RSAPKCSV15() {
            super(CryptMode.PKCS1_V15.toString());
            LOGGER.debug("RSACipher: being initialized for RSA/PKCS1_V15/PKCS5PADDING");
        }
    }

    public static final class RSAOAEPMgf1SHA512
    extends RSACipher {
        public RSAOAEPMgf1SHA512() {
            super(CryptMode.OAEP_MGF1_SHA512.toString());
            LOGGER.debug("RSACipher: being initialized for RSA/OAEP_MGF1_SHA512/PKCS5PADDING");
        }
    }

    public static final class RSAOAEPMgf1SHA384
    extends RSACipher {
        public RSAOAEPMgf1SHA384() {
            super(CryptMode.OAEP_MGF1_SHA384.toString());
            LOGGER.debug("RSACipher: being initialized for RSA/OAEP_MGF1_SHA384/PKCS5PADDING");
        }
    }

    public static final class RSAOAEPMgf1SHA256
    extends RSACipher {
        public RSAOAEPMgf1SHA256() {
            super(CryptMode.OAEP_MGF1_SHA256.toString());
            LOGGER.debug("RSACipher: being initialized for RSA/OAEP_MGF1_SHA256/PKCS5PADDING");
        }
    }

    public static final class RSAOAEPMgf1SHA1
    extends RSACipher {
        public RSAOAEPMgf1SHA1() {
            super(CryptMode.OAEP_MGF1_SHA1.toString());
            LOGGER.debug("RSACipher: being initialized for RSA/OAEP_MGF1_SHA1/PKCS5PADDING");
        }
    }
}

