/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.SdkmsCipherKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.jce.provider.util.ProviderUtil;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import org.slf4j.LoggerFactory;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class RSAPrivateKeyImpl
extends PKCS8Key
implements RSAPrivateKey,
SdkmsCipherKey {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(RSAPrivateKeyImpl.class));
    private SobjectDescriptor descriptor;
    private Integer keySize;
    private BigInteger modulus;
    private Boolean isExportable;
    private byte[] encoded;

    public RSAPrivateKeyImpl(SobjectDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public RSAPrivateKeyImpl(KeyObject keyObject) {
        this(SdkmsKeyService.getKeyDescriptor(keyObject));
        this.initFromKeyObject(keyObject);
    }

    @Deprecated
    public RSAPrivateKeyImpl(String keyId, Integer keySize, BigInteger modulus, String transientKey) {
        this(new SobjectDescriptor().kid(keyId).transientKey(transientKey));
        this.keySize = keySize;
        this.modulus = modulus;
    }

    private void initFromKeyObject(KeyObject keyObject) {
        this.keySize = keyObject.getKeySize();
        this.isExportable = keyObject.getKeyOps() != null && keyObject.getKeyOps().contains(KeyOperations.EXPORT);
        this.descriptor.setTransientKey(keyObject.getTransientKey());
        this.descriptor.setKid(keyObject.getKid());
        this.descriptor.setName(null);
        try {
            this.modulus = SdkmsKeyService.getRSAPrivateKeyModulus(keyObject);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            LOGGER.logAndRaiseProviderException("Unable to extract modulus for RSA private key.", e);
        }
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public BigInteger getModulus() {
        if (this.modulus == null) {
            KeyObject keyObject = SdkmsKeyService.getKeyObject(this.descriptor);
            this.initFromKeyObject(keyObject);
        }
        return this.modulus;
    }

    @Override
    public BigInteger getPrivateExponent() {
        try {
            DerInputStream der = new DerInputStream(this.getEncoded());
            DerValue[] data = der.getSequence(0);
            int ver = data[0].getInteger();
            if (ver != 0) {
                return null;
            }
            return data[3].getBigInteger();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "raw";
    }

    @Override
    public byte[] getEncoded() {
        if (this.isExportable == null) {
            KeyObject keyObject = SdkmsKeyService.getKeyObject(this.descriptor);
            this.initFromKeyObject(keyObject);
        }
        if (this.isExportable.booleanValue()) {
            if (this.encoded == null) {
                this.encoded = SdkmsKeyService.getKeyValue(this.descriptor);
            }
        } else {
            LOGGER.info("Trying to get key material of a non exportable key: " + ProviderUtil.toStringSobjectDescriptor(this.descriptor));
        }
        return this.encoded;
    }

    @Override
    public Integer getKeySize() {
        if (this.keySize != null) {
            return this.keySize;
        }
        KeyObject keyObject = SdkmsKeyService.getKeyObject(this.descriptor);
        this.initFromKeyObject(keyObject);
        return this.keySize;
    }

    @Override
    public SobjectDescriptor getKeyDescriptor() {
        return this.descriptor;
    }
}

