/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.SdkmsCipherKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPublicKey;
import org.slf4j.LoggerFactory;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.X509Key;

public class RSAPublicKeyImpl
extends X509Key
implements RSAPublicKey,
SdkmsCipherKey {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(RSAPublicKeyImpl.class));
    private BigInteger n;
    private BigInteger e;
    private SobjectDescriptor descriptor;
    private Integer keySize;

    public RSAPublicKeyImpl(SobjectDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public RSAPublicKeyImpl(KeyObject keyObject) {
        this(SdkmsKeyService.getKeyDescriptor(keyObject));
        this.initFromKeyObject(keyObject);
    }

    @Deprecated
    public RSAPublicKeyImpl(String keyId, Integer keySize, byte[] encoded, String transientKey) throws InvalidKeyException {
        this(new SobjectDescriptor().kid(keyId).transientKey(transientKey));
        this.keySize = keySize;
        try {
            this.decode(encoded);
        }
        catch (InvalidKeyException invalidKeyException) {
            LOGGER.logAndRaiseProviderException("Unable to decode RSA public key", invalidKeyException);
        }
    }

    private void initFromKeyObject(KeyObject keyObject) {
        this.keySize = keyObject.getKeySize();
        this.descriptor.setTransientKey(keyObject.getTransientKey());
        this.descriptor.setKid(keyObject.getKid());
        this.descriptor.setName(null);
        try {
            this.decode(keyObject.getPubKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            LOGGER.logAndRaiseProviderException("Unable to decode RSA public key", invalidKeyException);
        }
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.getKey().toByteArray());
            DerValue derValue = in.getDerValue();
            if (derValue.tag != 48) {
                throw new InvalidKeyException("Invalid RSA public key: Not a SEQUENCE");
            }
            DerInputStream data = derValue.data;
            this.n = this.getBigInteger(data);
            this.e = this.getBigInteger(data);
            if (derValue.data.available() != 0) {
                throw new InvalidKeyException("Invalid RSA public key: Extra data available");
            }
        }
        catch (IOException e) {
            throw new InvalidKeyException("Invalid RSA public key", e);
        }
    }

    private BigInteger getBigInteger(DerInputStream data) throws IOException {
        BigInteger b = data.getBigInteger();
        if (b.signum() < 0) {
            b = new BigInteger(1, b.toByteArray());
        }
        return b;
    }

    @Override
    public Integer getKeySize() {
        if (this.keySize != null) {
            return this.keySize;
        }
        KeyObject keyObject = SdkmsKeyService.getKeyObject(this.descriptor);
        this.initFromKeyObject(keyObject);
        return this.keySize;
    }

    @Override
    public SobjectDescriptor getKeyDescriptor() {
        return this.descriptor;
    }
}

