/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.RsaEncryptionPolicy;
import com.fortanix.sdkms.v1.model.RsaSignaturePolicy;
import java.security.spec.KeySpec;
import java.util.List;

public class SecurityObjectKeySpec
implements KeySpec {
    private List<KeyOperations> allowedKeyOperations;
    private RsaEncryptionPolicy rsaEncryptionPolicy;
    private RsaSignaturePolicy rsaSignaturePolicy;
    private String groupId;
    private KeySpec secretKeySpec;
    private boolean isTransientKey = true;
    private String alias;

    public SecurityObjectKeySpec(KeySpec secretKeySpec, String groupId) {
        this.groupId = groupId;
        this.secretKeySpec = secretKeySpec;
    }

    public SecurityObjectKeySpec(KeySpec secretKeySpec, List<KeyOperations> allowedKeyOperations) {
        this.allowedKeyOperations = allowedKeyOperations;
        this.secretKeySpec = secretKeySpec;
    }

    public SecurityObjectKeySpec(KeySpec secretKeySpec, boolean isTransientKey) {
        this.secretKeySpec = secretKeySpec;
        this.isTransientKey = isTransientKey;
    }

    public SecurityObjectKeySpec(List<KeyOperations> allowedKeyOperations) {
        if (allowedKeyOperations == null) {
            throw new IllegalArgumentException("allowedKeyOperations is null");
        }
        this.allowedKeyOperations = allowedKeyOperations;
    }

    public SecurityObjectKeySpec(boolean isTransientKey) {
        this.isTransientKey = isTransientKey;
    }

    public SecurityObjectKeySpec(KeySpec secretKeySpec, String groupId, String alias) {
        this.secretKeySpec = secretKeySpec;
        this.groupId = groupId;
        this.alias = alias;
    }

    public SecurityObjectKeySpec(KeySpec secretKeySpec, List<KeyOperations> allowedKeyOperations, RsaEncryptionPolicy rsaEncryptionPolicy, RsaSignaturePolicy rsaSignaturePolicy) {
        this(allowedKeyOperations);
        this.rsaEncryptionPolicy = rsaEncryptionPolicy;
        this.secretKeySpec = secretKeySpec;
        this.rsaSignaturePolicy = rsaSignaturePolicy;
    }

    public SecurityObjectKeySpec(KeySpec secretKeySpec, List<KeyOperations> allowedKeyOperations, RsaSignaturePolicy rsaSignaturePolicy) {
        this(allowedKeyOperations);
        this.rsaSignaturePolicy = rsaSignaturePolicy;
        this.secretKeySpec = secretKeySpec;
    }

    public SecurityObjectKeySpec(KeySpec secretKeySpec, List<KeyOperations> allowedKeyOperations, RsaEncryptionPolicy rsaEncryptionPolicy) {
        this(allowedKeyOperations);
        this.rsaEncryptionPolicy = rsaEncryptionPolicy;
        this.secretKeySpec = secretKeySpec;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setIsTransientKey(boolean isTransientKey) {
        this.isTransientKey = isTransientKey;
    }

    public List<KeyOperations> getAllowedKeyOperations() {
        return this.allowedKeyOperations;
    }

    public boolean getIsTransientKey() {
        return this.isTransientKey;
    }

    public KeySpec getKeySpec() {
        return this.secretKeySpec;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public RsaEncryptionPolicy getEncryptionPolicy() {
        return this.rsaEncryptionPolicy;
    }

    public RsaSignaturePolicy getSignaturePolicy() {
        return this.rsaSignaturePolicy;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

