/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.Configuration;
import com.fortanix.sdkms.jce.provider.service.ISdkmsCommand;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.v1.ApiClient;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.api.AuthenticationApi;
import com.fortanix.sdkms.v1.auth.ApiKeyAuth;
import com.fortanix.sdkms.v1.model.AuthResponse;
import com.fortanix.sdkms.v1.model.VersionResponse;
import java.util.Arrays;
import java.util.List;
import org.slf4j.LoggerFactory;

public class ApiClientSetup {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger((String)"SDKMS-API"));
    private static final List<Integer> invalidSessionCodes = Arrays.asList(401, 403);
    private static final List<String> invalidSessionMessages = Arrays.asList("Session does not exist", "Session has expired");
    public static String TRUST_STORE_ENV_VAR = "FORTANIX_SSL_TRUST_STORE";
    private static ApiClientSetup instance = new ApiClientSetup();
    private ApiClient apiClient;

    public static ApiClientSetup initialize() {
        instance = new ApiClientSetup();
        return instance;
    }

    public static ApiClientSetup getInstance() {
        return instance;
    }

    public Object ensureValidSession(ISdkmsCommand command) throws ApiException {
        Long startTS = System.currentTimeMillis();
        Object response = null;
        try {
            response = command.execute();
        }
        catch (ApiException apiException) {
            if (this.isSessionValid(apiException)) {
                throw apiException;
            }
            LOGGER.info("Session is expired. Trying re-login");
            this.makeLoginRequest();
            response = command.execute();
        }
        Long endTS = System.currentTimeMillis();
        LOGGER.info(command.getDescription() + ". Latency: " + (endTS - startTS) + "ms");
        return response;
    }

    private ApiClientSetup() {
        Configuration configuration = Configuration.getInstance();
        this.apiClient = new ApiClient();
        this.apiClient.setBasicAuthString(configuration.getSdkmsApiKey());
        this.apiClient.setBasePath(configuration.getSdkmsServerUrl());
        this.apiClient.setMaxConnections(configuration.getMaxConn());
        this.apiClient.setKeepAliveDuration(configuration.getKeepAliveDuration());
        if (System.getenv(TRUST_STORE_ENV_VAR) != null) {
            System.setProperty("javax.net.ssl.trustStore", System.getenv(TRUST_STORE_ENV_VAR));
        }
    }

    public boolean isSessionValid(ApiException apiException) {
        if (invalidSessionCodes.contains(apiException.getCode())) {
            return false;
        }
        for (String invalidMessage : invalidSessionMessages) {
            if (!apiException.getMessage().contains(invalidMessage)) continue;
            return false;
        }
        return true;
    }

    public void makeLoginRequest() {
        try {
            Long startTS = System.currentTimeMillis();
            AuthResponse authResponse = new AuthenticationApi(this.apiClient).authorize();
            String bearerToken = authResponse.getAccessToken();
            ApiKeyAuth bearerAuth = (ApiKeyAuth)this.apiClient.getAuthentication("bearerToken");
            bearerAuth.setApiKey(bearerToken);
            bearerAuth.setApiKeyPrefix("Bearer");
            Long endTS = System.currentTimeMillis();
            LOGGER.info("Authentication. Latency: " + (endTS - startTS) + "ms");
        }
        catch (ApiException e) {
            LOGGER.logAndRaiseProviderException("SDKMS authentication Failed", e);
        }
    }

    public String getServerVersion() {
        try {
            VersionResponse versionResponse = new AuthenticationApi(this.apiClient).getServerVersion();
            return versionResponse.getVersion();
        }
        catch (ApiException e) {
            LOGGER.logAndRaiseProviderException("SDKMS version fetch failed", e);
            return null;
        }
    }

    public void logout() {
        try {
            LOGGER.info("Session Termination");
            new AuthenticationApi(this.apiClient).terminate();
        }
        catch (ApiException apiException) {
            // empty catch block
        }
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }
}

