/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SecurityObjectRequest;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.EllipticCurve;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.List;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public class SdKmsEc {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdKmsEc.class));

    public static KeyObject generateKeyForEcOperation(EllipticCurve curve, List<KeyOperations> allowedKeyOperations, boolean isTransientKey) {
        KeyObject keyObject = null;
        try {
            String securityObjectName = UUID.randomUUID().toString();
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            securityObjectRequest.setObjType(ObjectType.EC);
            if (allowedKeyOperations != null) {
                securityObjectRequest.setKeyOps(allowedKeyOperations);
            }
            securityObjectRequest.setName(securityObjectName);
            securityObjectRequest.setEllipticCurve(curve);
            securityObjectRequest.setTransient(Boolean.valueOf(isTransientKey));
            keyObject = new SecurityObjectRequest().makeGenerate(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Failed to generate EC Key Pair for curve : " + curve, apiException);
        }
        return keyObject;
    }

    public static KeyObject importKeyForEcOperation(List<KeyOperations> allowedKeyOperations, byte[] material, String alias) {
        KeyObject keyObject = null;
        try {
            if (alias == null || alias.isEmpty()) {
                alias = UUID.randomUUID().toString();
            }
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            securityObjectRequest.setObjType(ObjectType.EC);
            if (allowedKeyOperations != null) {
                securityObjectRequest.setKeyOps(allowedKeyOperations);
            }
            securityObjectRequest.setName(alias);
            securityObjectRequest.setValue(material);
            keyObject = new SecurityObjectRequest().makeImport(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Failed to import EC Key Pair", apiException);
        }
        return keyObject;
    }
}

