/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SecurityObjectRequest;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.List;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public final class SdkmsAes {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsAes.class));

    public static KeyObject generateKeyForAesOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, boolean isTransientKey) {
        KeyObject keyObject = null;
        try {
            String securityObjectName = UUID.randomUUID().toString();
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            if (allowedKeyOperations != null) {
                securityObjectRequest.setKeyOps(allowedKeyOperations);
            }
            securityObjectRequest.setObjType(ObjectType.AES);
            securityObjectRequest.setName(securityObjectName);
            securityObjectRequest.setKeySize(keySize);
            securityObjectRequest.setTransient(Boolean.valueOf(isTransientKey));
            keyObject = new SecurityObjectRequest().makeGenerate(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Aes Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }

    public static KeyObject importAESKey(byte[] keyMaterial, Integer keySize, List<KeyOperations> allowedKeyOperations, String alias) {
        KeyObject keyObject = null;
        try {
            if (alias == null || alias.isEmpty()) {
                alias = UUID.randomUUID().toString();
            }
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            if (allowedKeyOperations != null) {
                securityObjectRequest.setKeyOps(allowedKeyOperations);
            }
            securityObjectRequest.setObjType(ObjectType.AES);
            securityObjectRequest.setName(alias);
            securityObjectRequest.setKeySize(keySize);
            securityObjectRequest.setValue(keyMaterial);
            keyObject = new SecurityObjectRequest().makeImport(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Aes Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }
}

