/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SecurityObjectRequest;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.List;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public final class SdkmsDes {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsDes.class));

    public static KeyObject generateKeyForDesOperation(Integer keySize, List<KeyOperations> allowedKeyOperation, boolean isTransientKey) {
        KeyObject keyObject = null;
        try {
            String securityObjectName = UUID.randomUUID().toString();
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            if (allowedKeyOperation != null) {
                securityObjectRequest.setKeyOps(allowedKeyOperation);
            }
            securityObjectRequest.setObjType(ObjectType.DES);
            securityObjectRequest.setName(securityObjectName);
            securityObjectRequest.setKeySize(keySize);
            securityObjectRequest.setTransient(Boolean.valueOf(isTransientKey));
            keyObject = new SecurityObjectRequest().makeGenerate(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Des Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }

    public static KeyObject importKeyForDesOperation(Integer keySize, List<KeyOperations> allowedKeyOperation, byte[] material, String alias) {
        KeyObject keyObject = null;
        try {
            if (alias == null || alias.isEmpty()) {
                alias = UUID.randomUUID().toString();
            }
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            if (allowedKeyOperation != null) {
                securityObjectRequest.setKeyOps(allowedKeyOperation);
            }
            securityObjectRequest.setObjType(ObjectType.DES);
            securityObjectRequest.setName(alias);
            securityObjectRequest.setKeySize(keySize);
            if (material != null) {
                securityObjectRequest.setValue(material);
            }
            keyObject = new SecurityObjectRequest().makeImport(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Des Key import keySize : " + keySize, apiException);
        }
        return keyObject;
    }

    public static KeyObject generateKeyForDesedeOperation(Integer keySize, List<KeyOperations> allowedKeyOperation, boolean isTransientKey) {
        KeyObject keyObject = null;
        try {
            String securityObjectName = UUID.randomUUID().toString();
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            if (allowedKeyOperation != null) {
                securityObjectRequest.setKeyOps(allowedKeyOperation);
            }
            securityObjectRequest.setObjType(ObjectType.DES3);
            securityObjectRequest.setName(securityObjectName);
            securityObjectRequest.setKeySize(keySize);
            securityObjectRequest.setTransient(Boolean.valueOf(isTransientKey));
            keyObject = new SecurityObjectRequest().makeGenerate(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during TripleDES/DESede Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }

    public static KeyObject importKeyForDesedeOperation(Integer keySize, List<KeyOperations> allowedKeyOperation, byte[] material) {
        KeyObject keyObject = null;
        try {
            String securityObjectName = UUID.randomUUID().toString();
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            if (allowedKeyOperation != null) {
                securityObjectRequest.setKeyOps(allowedKeyOperation);
            }
            securityObjectRequest.setObjType(ObjectType.DES3);
            securityObjectRequest.setName(securityObjectName);
            securityObjectRequest.setKeySize(keySize);
            if (material != null) {
                securityObjectRequest.value(material);
            }
            keyObject = new SecurityObjectRequest().makeImport(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during TripleDES/DESede Key Import keySize : " + keySize, apiException);
        }
        return keyObject;
    }
}

