/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.service.ApiClientSetup;
import com.fortanix.sdkms.jce.provider.service.ISdkmsCommand;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.api.SignAndVerifyApi;
import com.fortanix.sdkms.v1.model.DigestAlgorithm;
import com.fortanix.sdkms.v1.model.SignRequestEx;
import com.fortanix.sdkms.v1.model.SignResponse;
import com.fortanix.sdkms.v1.model.SignatureMode;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import com.fortanix.sdkms.v1.model.VerifyRequestEx;
import com.fortanix.sdkms.v1.model.VerifyResponse;
import org.slf4j.LoggerFactory;

public class SdkmsSignature {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsSignature.class));

    public static SignResponse signDigest(byte[] hash, DigestAlgorithm alg, SobjectDescriptor sobjectDescriptor, SignatureMode signatureMode) {
        SignResponse signResponse = null;
        try {
            final SignRequestEx signRequestEx = new SignRequestEx().hashAlg(alg).hash(hash).key(sobjectDescriptor).mode(signatureMode);
            signResponse = (SignResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new SignAndVerifyApi(ApiClientSetup.getInstance().getApiClient()).signEx(signRequestEx);
                }

                @Override
                public String getDescription() {
                    return "Signing";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Failed to sign data", apiException);
        }
        return signResponse;
    }

    public static SignResponse signData(byte[] data, DigestAlgorithm alg, SobjectDescriptor sobjectDescriptor, SignatureMode signatureMode) {
        SignResponse signResponse = null;
        try {
            final SignRequestEx signRequestEx = new SignRequestEx().hashAlg(alg).data(data).key(sobjectDescriptor).mode(signatureMode);
            signResponse = (SignResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new SignAndVerifyApi(ApiClientSetup.getInstance().getApiClient()).signEx(signRequestEx);
                }

                @Override
                public String getDescription() {
                    return "Signing";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Failed to sign data", apiException);
        }
        return signResponse;
    }

    public static VerifyResponse verifyDigest(byte[] signature, byte[] hash, DigestAlgorithm alg, SobjectDescriptor sobjectDescriptor, SignatureMode signatureMode) {
        VerifyResponse verifyResponse = null;
        try {
            final VerifyRequestEx verifyRequestEx = new VerifyRequestEx().hashAlg(alg).hash(hash).signature(signature).key(sobjectDescriptor).mode(signatureMode);
            verifyResponse = (VerifyResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new SignAndVerifyApi(ApiClientSetup.getInstance().getApiClient()).verifyEx(verifyRequestEx);
                }

                @Override
                public String getDescription() {
                    return "SignatureVerification";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error verifying signature", apiException);
        }
        return verifyResponse;
    }

    public static VerifyResponse verifyData(byte[] signature, byte[] data, DigestAlgorithm alg, SobjectDescriptor sobjectDescriptor, SignatureMode signatureMode) {
        VerifyResponse verifyResponse = null;
        try {
            final VerifyRequestEx verifyRequestEx = new VerifyRequestEx().hashAlg(alg).data(data).signature(signature).key(sobjectDescriptor).mode(signatureMode);
            verifyResponse = (VerifyResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new SignAndVerifyApi(ApiClientSetup.getInstance().getApiClient()).verifyEx(verifyRequestEx);
                }

                @Override
                public String getDescription() {
                    return "SignatureVerification";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error verifying signature", apiException);
        }
        return verifyResponse;
    }
}

