/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.util;

import com.fortanix.sdkms.v1.model.DigestAlgorithm;
import com.fortanix.sdkms.v1.model.EllipticCurve;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;

public class ProviderUtil {
    public static String getSunAlgoForMessageDigest(DigestAlgorithm alg) {
        if (DigestAlgorithm.SHA1.equals(alg)) {
            return "SHA-1";
        }
        if (DigestAlgorithm.SHA256.equals(alg)) {
            return "SHA-256";
        }
        if (DigestAlgorithm.SHA384.equals(alg)) {
            return "SHA-384";
        }
        if (DigestAlgorithm.SHA512.equals(alg)) {
            return "SHA-512";
        }
        return "";
    }

    public static boolean isVersionGE(String serverVersion, String checkVersion) {
        if (serverVersion == null || checkVersion == null) {
            return false;
        }
        String[] serverVersions = serverVersion.split("\\.");
        if (serverVersions.length < 1 || serverVersions.length > 3) {
            return false;
        }
        String[] checkVersions = checkVersion.split("\\.");
        if (checkVersions.length < 1 || checkVersions.length > 3) {
            return false;
        }
        try {
            if (Integer.parseInt(serverVersions[0]) < Integer.parseInt(checkVersions[0])) {
                return false;
            }
            if (checkVersions.length >= 2 && Integer.parseInt(serverVersions[1]) < Integer.parseInt(checkVersions[1])) {
                return false;
            }
            return checkVersions.length != 3 || Integer.parseInt(serverVersions[2]) >= Integer.parseInt(checkVersions[2]);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String toStringSobjectDescriptor(SobjectDescriptor descriptor) {
        if (descriptor.getTransientKey() != null) {
            return "{ transientKey: true }";
        }
        if (descriptor.getName() != null) {
            return "{ name: " + descriptor.getName() + " }";
        }
        return "{ keyId: " + descriptor.getKid() + " }";
    }

    public static enum ECKeySizeSpec {
        SecP192K1(EllipticCurve.SECP192K1, 192),
        SecP224K1(EllipticCurve.SECP224K1, 224),
        SecP256K1(EllipticCurve.SECP256K1, 256),
        NistP192(EllipticCurve.NISTP192, 192),
        NistP224(EllipticCurve.NISTP224, 224),
        NistP256(EllipticCurve.NISTP256, 256),
        NistP384(EllipticCurve.NISTP384, 384),
        NistP521(EllipticCurve.NISTP521, 521),
        Secp192r1(EllipticCurve.SECP192K1, 192),
        Secp224r1(EllipticCurve.SECP224K1, 224),
        Secp256r1(EllipticCurve.SECP256K1, 256);

        private final EllipticCurve key;
        private final int value;

        private ECKeySizeSpec(EllipticCurve key, int value) {
            this.value = value;
            this.key = key;
        }

        public int getValue() {
            return this.value;
        }

        public EllipticCurve getKey() {
            return this.key;
        }

        public static ECKeySizeSpec getByKey(String key) {
            for (ECKeySizeSpec current : ECKeySizeSpec.values()) {
                if (!current.key.toString().equalsIgnoreCase(key)) continue;
                return current;
            }
            return null;
        }
    }

    public static enum DigestAlgorithms {
        SHA1("SHA1", DigestAlgorithm.SHA1),
        SHA256("SHA-256", DigestAlgorithm.SHA256),
        SHA384("SHA-384", DigestAlgorithm.SHA384),
        SHA512("SHA-512", DigestAlgorithm.SHA512),
        STREEBOG256("Streebog-256", DigestAlgorithm.STREEBOG256),
        STREEBOG512("Streebog-512", DigestAlgorithm.STREEBOG512);

        private final String key;
        private final DigestAlgorithm value;

        private DigestAlgorithms(String key, DigestAlgorithm value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public DigestAlgorithm getValue() {
            return this.value;
        }

        public static DigestAlgorithms getByKey(String key) {
            for (DigestAlgorithms current : DigestAlgorithms.values()) {
                if (!current.key.equalsIgnoreCase(key)) continue;
                return current;
            }
            return null;
        }
    }

    public static enum ECGenSpec {
        SecP192K1("secp192k1", EllipticCurve.SECP192K1),
        SecP224K1("secp224k1", EllipticCurve.SECP224K1),
        SecP256K1("secp256k1", EllipticCurve.SECP256K1),
        NistP192("NIST P-192", EllipticCurve.NISTP192),
        NistP224("NIST P-224", EllipticCurve.NISTP224),
        NistP256("NIST P-256", EllipticCurve.NISTP256),
        NistP384("NIST P-384", EllipticCurve.NISTP384),
        NistP521("NIST P-521", EllipticCurve.NISTP521),
        Secp192r1("secp192r1", EllipticCurve.NISTP192),
        Secp224r1("secp224r1", EllipticCurve.NISTP224),
        Secp256r1("secp256r1", EllipticCurve.NISTP256),
        Secp384r1("secp384r1", EllipticCurve.NISTP384),
        Secp521r1("secp521r1", EllipticCurve.NISTP521),
        Gost256a("GOST 256A", EllipticCurve.GOST256A),
        Ed25519("Ed25519", EllipticCurve.ED25519),
        X25519("X25519", EllipticCurve.X25519),
        X448("X448", EllipticCurve.X448);

        private final String key;
        private final EllipticCurve value;

        private ECGenSpec(String key, EllipticCurve value) {
            this.value = value;
            this.key = key;
        }

        public EllipticCurve getValue() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }

        public static ECGenSpec getByKey(String key) {
            for (ECGenSpec current : ECGenSpec.values()) {
                if (!current.key.equalsIgnoreCase(key)) continue;
                return current;
            }
            return null;
        }
    }
}

