/*
 * Decompiled with CFR 0.152.
 */
package com.gemnasium;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.gemnasium.AbstractMainMojo;
import com.gemnasium.utils.ProjectsUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dump-dependencies", requiresDependencyCollection=ResolutionScope.TEST)
public class DumpDependenciesMojo
extends AbstractMainMojo {
    public static final String DEPENDENCY_FILE_NAME = "gemnasium-maven-plugin.json";

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        this.listDependencies();
    }

    public void listDependencies() throws MojoExecutionException {
        ArrayNode jsonDependencies = ProjectsUtils.getJsonDependencies(this.getAllDependencies(), this.getDirectDependencies());
        String output = jsonDependencies.toString();
        String filePath = this.config.getBaseDir() + "/" + DEPENDENCY_FILE_NAME;
        try {
            Files.write(Paths.get(filePath, new String[0]), output.getBytes(), StandardOpenOption.CREATE);
            this.getLog().info((CharSequence)("Project's dependencies have been succesfully dumped into: " + filePath));
        }
        catch (IOException e) {
            this.getLog().info((CharSequence)("Can't write project's dependencies into: " + filePath));
            e.printStackTrace();
        }
    }
}

