/*
 * Decompiled with CFR 0.152.
 */
package com.ginsberg.junit.exit;

import com.ginsberg.junit.exit.SystemExitPreventedException;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;

public class DisallowExitSecurityManager
extends SecurityManager {
    private final SecurityManager delegatedSecurityManager;
    private Integer firstExitStatusCode;

    public DisallowExitSecurityManager(SecurityManager originalSecurityManager) {
        this.delegatedSecurityManager = originalSecurityManager;
    }

    @Override
    public void checkExit(int statusCode) {
        if (this.firstExitStatusCode == null) {
            this.firstExitStatusCode = statusCode;
        }
        throw new SystemExitPreventedException();
    }

    public Integer getFirstExitStatusCode() {
        return this.firstExitStatusCode;
    }

    @Override
    public Object getSecurityContext() {
        return this.delegatedSecurityManager == null ? null : this.delegatedSecurityManager.getSecurityContext();
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkPermission(perm, context);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkCreateClassLoader();
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkAccess(g);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkLink(lib);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkRead(fd);
        }
    }

    @Override
    public void checkRead(String file) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkRead(file);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkRead(file, context);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkWrite(fd);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkDelete(file);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkConnect(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkAccept(host, port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkMulticast(maddr);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkPropertyAccess(key);
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkPrintJobAccess();
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkSetFactory();
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (this.delegatedSecurityManager != null) {
            this.delegatedSecurityManager.checkSecurityAccess(target);
        }
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.delegatedSecurityManager == null ? null : this.delegatedSecurityManager.getThreadGroup();
    }
}

