/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.core.MethodParameter;
import org.springframework.util.ReflectionUtils;

public class InjectBeanPostProcessor
implements BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(InjectBeanPostProcessor.class);
    private ConfigurableListableBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("AutowiredAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory: " + beanFactory);
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public InjectionMetadata.InjectedElement createAutowiredMethodElement(Method method, boolean required, PropertyDescriptor pd) {
        return new AutowiredMethodElement(method, required, pd);
    }

    public InjectionMetadata.InjectedElement createAutowiredFieldElement(Field field, boolean required) {
        return new AutowiredFieldElement(field, required);
    }

    private void registerDependentBeans(String beanName, Set<String> autowiredBeanNames) {
        if (beanName != null) {
            for (String autowiredBeanName : autowiredBeanNames) {
                if (this.beanFactory.containsBean(autowiredBeanName)) {
                    this.beanFactory.registerDependentBean(autowiredBeanName, beanName);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Autowiring by type from bean name '" + beanName + "' to bean named '" + autowiredBeanName + "'");
            }
        }
    }

    private Object resolvedCachedArgument(String beanName, Object cachedArgument) {
        if (cachedArgument instanceof DependencyDescriptor) {
            DependencyDescriptor descriptor = (DependencyDescriptor)cachedArgument;
            return this.beanFactory.resolveDependency(descriptor, beanName, null, null);
        }
        return cachedArgument;
    }

    private static class ShortcutDependencyDescriptor
    extends DependencyDescriptor {
        private final String shortcut;
        private final Class<?> requiredType;

        public ShortcutDependencyDescriptor(DependencyDescriptor original, String shortcut, Class<?> requiredType) {
            super(original);
            this.shortcut = shortcut;
            this.requiredType = requiredType;
        }

        public Object resolveShortcut(BeanFactory beanFactory) {
            return this.resolveCandidate(this.shortcut, this.requiredType, beanFactory);
        }
    }

    private class AutowiredMethodElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;
        private volatile boolean cached;
        private volatile Object[] cachedMethodArguments;

        public AutowiredMethodElement(Method method, boolean required, PropertyDescriptor pd) {
            super((Member)method, pd);
            this.cached = false;
            this.required = required;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Object[] arguments;
            if (this.checkPropertySkipping(pvs)) {
                return;
            }
            Method method = (Method)this.member;
            if (this.cached) {
                arguments = this.resolveCachedArguments(beanName);
            } else {
                Class<?>[] paramTypes = method.getParameterTypes();
                arguments = new Object[paramTypes.length];
                DependencyDescriptor[] descriptors = new DependencyDescriptor[paramTypes.length];
                LinkedHashSet autowiredBeans = new LinkedHashSet(paramTypes.length);
                TypeConverter typeConverter = InjectBeanPostProcessor.this.beanFactory.getTypeConverter();
                for (int i = 0; i < arguments.length; ++i) {
                    MethodParameter methodParam = new MethodParameter(method, i);
                    DependencyDescriptor currDesc = new DependencyDescriptor(methodParam, this.required);
                    currDesc.setContainingClass(bean.getClass());
                    descriptors[i] = currDesc;
                    try {
                        Object arg = InjectBeanPostProcessor.this.beanFactory.resolveDependency(currDesc, beanName, autowiredBeans, typeConverter);
                        if (arg == null && !this.required) {
                            arguments = null;
                            break;
                        }
                        arguments[i] = arg;
                        continue;
                    }
                    catch (BeansException ex) {
                        throw new UnsatisfiedDependencyException(null, beanName, new InjectionPoint(methodParam), ex);
                    }
                }
                AutowiredMethodElement autowiredMethodElement = this;
                synchronized (autowiredMethodElement) {
                    if (!this.cached) {
                        if (arguments != null) {
                            this.cachedMethodArguments = new Object[paramTypes.length];
                            for (int i = 0; i < arguments.length; ++i) {
                                this.cachedMethodArguments[i] = descriptors[i];
                            }
                            InjectBeanPostProcessor.this.registerDependentBeans(beanName, autowiredBeans);
                            if (autowiredBeans.size() == paramTypes.length) {
                                Iterator it = autowiredBeans.iterator();
                                for (int i = 0; i < paramTypes.length; ++i) {
                                    String autowiredBeanName = (String)it.next();
                                    if (!InjectBeanPostProcessor.this.beanFactory.containsBean(autowiredBeanName) || !InjectBeanPostProcessor.this.beanFactory.isTypeMatch(autowiredBeanName, paramTypes[i])) continue;
                                    this.cachedMethodArguments[i] = new ShortcutDependencyDescriptor(descriptors[i], autowiredBeanName, paramTypes[i]);
                                }
                            }
                        } else {
                            this.cachedMethodArguments = null;
                        }
                        this.cached = true;
                    }
                }
            }
            if (arguments != null) {
                try {
                    ReflectionUtils.makeAccessible((Method)method);
                    method.invoke(bean, arguments);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
        }

        private Object[] resolveCachedArguments(String beanName) {
            if (this.cachedMethodArguments == null) {
                return null;
            }
            Object[] arguments = new Object[this.cachedMethodArguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = InjectBeanPostProcessor.this.resolvedCachedArgument(beanName, this.cachedMethodArguments[i]);
            }
            return arguments;
        }
    }

    private class AutowiredFieldElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;
        private volatile boolean cached;
        private volatile Object cachedFieldValue;

        public AutowiredFieldElement(Field field, boolean required) {
            super((Member)field, null);
            this.cached = false;
            this.required = required;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Object value;
            Field field = (Field)this.member;
            if (this.cached) {
                value = InjectBeanPostProcessor.this.resolvedCachedArgument(beanName, this.cachedFieldValue);
            } else {
                DependencyDescriptor desc = new DependencyDescriptor(field, this.required);
                desc.setContainingClass(bean.getClass());
                LinkedHashSet autowiredBeanNames = new LinkedHashSet(1);
                TypeConverter typeConverter = InjectBeanPostProcessor.this.beanFactory.getTypeConverter();
                try {
                    value = InjectBeanPostProcessor.this.beanFactory.resolveDependency(desc, beanName, autowiredBeanNames, typeConverter);
                }
                catch (BeansException ex) {
                    throw new UnsatisfiedDependencyException(null, beanName, new InjectionPoint(field), ex);
                }
                AutowiredFieldElement autowiredFieldElement = this;
                synchronized (autowiredFieldElement) {
                    if (!this.cached) {
                        if (value != null || this.required) {
                            this.cachedFieldValue = desc;
                            InjectBeanPostProcessor.this.registerDependentBeans(beanName, autowiredBeanNames);
                            if (autowiredBeanNames.size() == 1) {
                                String autowiredBeanName = (String)autowiredBeanNames.iterator().next();
                                if (InjectBeanPostProcessor.this.beanFactory.containsBean(autowiredBeanName) && InjectBeanPostProcessor.this.beanFactory.isTypeMatch(autowiredBeanName, field.getType())) {
                                    this.cachedFieldValue = new ShortcutDependencyDescriptor(desc, autowiredBeanName, field.getType());
                                }
                            }
                        } else {
                            this.cachedFieldValue = null;
                        }
                        this.cached = true;
                    }
                }
            }
            if (value != null) {
                ReflectionUtils.makeAccessible((Field)field);
                field.set(bean, value);
            }
        }
    }
}

