/*
 * Decompiled with CFR 0.152.
 */
package com.reger.dubbo.rpc.filter;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.reger.dubbo.rpc.filter.JoinPoint;
import com.reger.dubbo.rpc.filter.RpcFilter;
import com.reger.dubbo.rpc.filter.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProceedingJoinPoint<T>
implements JoinPoint<T> {
    private static final Logger log = LoggerFactory.getLogger(ProceedingJoinPoint.class);
    private final Invoker<T> invoker;
    private final Invocation invocation;
    private final List<? extends RpcFilter> filters;
    private volatile int index = 0;
    private volatile int filterCount = 0;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    protected ProceedingJoinPoint(Invoker<T> invoker, Invocation invocation, List<? extends RpcFilter> rpcFilters) {
        this.invoker = invoker;
        this.invocation = invocation;
        this.filters = rpcFilters;
        if (this.filters != null) {
            this.filterCount = this.filters.size();
        }
    }

    @Override
    public Result proceed() {
        if (this.index >= this.filterCount) {
            log.debug("\u8fc7\u6ee4\u5668\u8c03\u7528\u5b8c\u6bd5\uff0c\u5f00\u59cb\u6267\u884c\u771f\u5b9e\u8c03\u7528 ,  {}", (Object)this.invoker.getInterface());
            return Utils.decodeException(this.invoker.invoke(this.invocation));
        }
        log.debug("\u6ce8\u518c\u4e86{}\u4e2a\u8fc7\u6ee4\u5668\uff0c\u5f53\u524d\u8c03\u7528\u7b2c{}\u4e2a,\u8fc7\u6ee4\u5668\u901a\u8fc7beanName\u6392\u5e8f", (Object)this.filterCount, (Object)this.index);
        RpcFilter rpcFilter = this.filters.get(this.index++);
        return rpcFilter.invoke(this);
    }

    public Invoker<T> getInvoker() {
        return this.invoker;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    @Override
    public Class<T> getInterface() {
        return this.invoker.getInterface();
    }

    public URL getUrl() {
        return this.invoker.getUrl();
    }

    public boolean isAvailable() {
        return this.invoker.isAvailable();
    }

    public void destroy() {
        this.invoker.destroy();
    }

    @Override
    public String getMethodName() {
        return this.invocation.getMethodName();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.invocation.getParameterTypes();
    }

    @Override
    public Object[] getArguments() {
        return this.invocation.getArguments();
    }

    @Override
    public Map<String, String> getAttachments() {
        return this.invocation.getAttachments();
    }

    @Override
    public String getAttachment(String key) {
        return this.invocation.getAttachment(key);
    }

    @Override
    public String getAttachment(String key, String defaultValue) {
        return this.invocation.getAttachment(key, defaultValue);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }
}

