/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.github.adejanovski.cassandra.jdbc.AbstractJdbcUUID;
import com.github.adejanovski.cassandra.jdbc.MarshalException;
import java.nio.ByteBuffer;
import java.util.UUID;

public class JdbcUUID
extends AbstractJdbcUUID {
    public static final JdbcUUID instance = new JdbcUUID();

    JdbcUUID() {
    }

    public UUID compose(ByteBuffer bytes) {
        if ((bytes = bytes.slice()).remaining() < 16) {
            return new UUID(0L, 0L);
        }
        return new UUID(bytes.getLong(), bytes.getLong());
    }

    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes");
        }
        return this.compose(bytes).toString();
    }

    @Override
    public UUID compose(Object obj) {
        return UUID.fromString(obj.toString());
    }

    @Override
    public Object decompose(UUID obj) {
        return obj;
    }
}

