/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.github.adejanovski.cassandra.jdbc.AbstractStatement;
import com.github.adejanovski.cassandra.jdbc.CassandraPreparedStatement;
import com.github.adejanovski.cassandra.jdbc.ManagedConnection;
import com.github.adejanovski.cassandra.jdbc.PooledCassandraConnection;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class ManagedPreparedStatement
extends AbstractStatement
implements PreparedStatement {
    private PooledCassandraConnection pooledCassandraConnection;
    private ManagedConnection managedConnection;
    private CassandraPreparedStatement preparedStatement;
    private boolean poolable;

    ManagedPreparedStatement(PooledCassandraConnection pooledCassandraConnection, ManagedConnection managedConnection, CassandraPreparedStatement preparedStatement) {
        this.pooledCassandraConnection = pooledCassandraConnection;
        this.managedConnection = managedConnection;
        this.preparedStatement = preparedStatement;
    }

    private void checkNotClosed() throws SQLNonTransientConnectionException {
        if (this.isClosed()) {
            throw new SQLNonTransientConnectionException("method was called on a closed Connection");
        }
    }

    @Override
    public ManagedConnection getConnection() throws SQLException {
        return this.managedConnection;
    }

    @Override
    public boolean isClosed() {
        return this.preparedStatement == null || this.preparedStatement.isClosed();
    }

    @Override
    public void close() throws SQLNonTransientConnectionException {
        this.checkNotClosed();
        this.pooledCassandraConnection.statementClosed(this.preparedStatement);
        this.preparedStatement = null;
    }

    @Override
    public boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.poolable = poolable;
    }

    public int hashCode() {
        return this.preparedStatement.getCql().hashCode();
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.addBatch(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.clearBatch();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.clearWarnings();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.execute(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.execute(arg0, arg1);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.executeBatch();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.executeQuery(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int executeUpdate(String arg0) throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.executeUpdate(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.executeUpdate(arg0, arg1);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getFetchDirection();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getFetchSize();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getMaxFieldSize();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getMaxRows();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getMoreResults();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getMoreResults(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getQueryTimeout();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getResultSet();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getResultSetConcurrency();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getResultSetHoldability();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getResultSetType();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getUpdateCount();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getWarnings();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setEscapeProcessing(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setFetchDirection(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setFetchSize(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setMaxFieldSize(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setMaxRows(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setQueryTimeout(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.isWrapperFor(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.unwrap(arg0);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.addBatch();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.clearParameters();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.execute();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.executeQuery();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.executeUpdate();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getMetaData();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkNotClosed();
        try {
            return this.preparedStatement.getParameterMetaData();
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setBoolean(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setByte(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setBytes(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setDate(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setDate(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setDouble(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setFloat(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setInt(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setLong(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setNString(parameterIndex, value);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setNull(parameterIndex, sqlType);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setNull(parameterIndex, sqlType, typeName);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setObject(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setRowId(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setShort(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setString(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setTime(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setTime(parameterIndex, x, cal);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setTimestamp(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setURL(parameterIndex, x);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob value) throws SQLException {
        this.checkNotClosed();
        try {
            this.preparedStatement.setBlob(parameterIndex, value);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream value) throws SQLException {
        try {
            this.preparedStatement.setBlob(parameterIndex, value);
        }
        catch (SQLException sqlException) {
            this.pooledCassandraConnection.statementErrorOccurred(this.preparedStatement, sqlException);
            throw sqlException;
        }
    }
}

