/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TableMetadata;
import com.github.adejanovski.cassandra.jdbc.AbstractJdbcType;
import com.github.adejanovski.cassandra.jdbc.CassandraMetadataResultSet;
import com.github.adejanovski.cassandra.jdbc.CassandraStatement;
import com.github.adejanovski.cassandra.jdbc.JdbcAscii;
import com.github.adejanovski.cassandra.jdbc.JdbcBytes;
import com.github.adejanovski.cassandra.jdbc.JdbcInt32;
import com.github.adejanovski.cassandra.jdbc.JdbcLong;
import com.github.adejanovski.cassandra.jdbc.JdbcUTF8;
import com.github.adejanovski.cassandra.jdbc.JdbcUUID;
import com.github.adejanovski.cassandra.jdbc.MetadataResultSet;
import com.github.adejanovski.cassandra.jdbc.MetadataRow;
import com.github.adejanovski.cassandra.jdbc.TypesMap;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MetadataResultSets {
    static final String TABLE_CONSTANT = "TABLE";
    public static final MetadataResultSets instance = new MetadataResultSets();

    private MetadataResultSets() {
    }

    private static final MetadataRow makeColumn(String name, String value) {
        return new MetadataRow().addEntry(name, value);
    }

    public CassandraMetadataResultSet makeTableTypes(CassandraStatement statement) throws SQLException {
        ArrayList tableTypes = Lists.newArrayList();
        MetadataRow row = new MetadataRow().addEntry("TABLE_TYPE", TABLE_CONSTANT);
        tableTypes.add(row);
        CassandraMetadataResultSet result = new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(tableTypes));
        return result;
    }

    public CassandraMetadataResultSet makeCatalogs(CassandraStatement statement) throws SQLException {
        ArrayList catalog = Lists.newArrayList();
        MetadataRow row = new MetadataRow().addEntry("TABLE_CAT", statement.connection.getCatalog());
        catalog.add(row);
        CassandraMetadataResultSet result = new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(catalog));
        return result;
    }

    public CassandraMetadataResultSet makeSchemas(CassandraStatement statement, String schemaPattern) throws SQLException {
        ArrayList schemas = Lists.newArrayList();
        List keyspaces = statement.connection.getClusterMetadata().getKeyspaces();
        for (KeyspaceMetadata keyspace : keyspaces) {
            if ("%".equals(schemaPattern)) {
                schemaPattern = null;
            }
            if (!(schemaPattern == null ? keyspace.getName() : schemaPattern).equals(keyspace.getName())) continue;
            MetadataRow row = new MetadataRow().addEntry("TABLE_SCHEM", keyspace.getName()).addEntry("TABLE_CATALOG", statement.connection.getCatalog());
            schemas.add(row);
        }
        CassandraMetadataResultSet result = new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(schemas));
        return result;
    }

    public CassandraMetadataResultSet makeTables(CassandraStatement statement, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList schemas = Lists.newArrayList();
        List keyspaces = statement.connection.getClusterMetadata().getKeyspaces();
        for (KeyspaceMetadata keyspace : keyspaces) {
            if ("%".equals(schemaPattern)) {
                schemaPattern = null;
            }
            if (!(schemaPattern == null ? keyspace.getName() : schemaPattern).equals(keyspace.getName())) continue;
            Collection tables = keyspace.getTables();
            if ("%".equals(tableNamePattern)) {
                tableNamePattern = null;
            }
            Iterator iterator = tables.iterator();
            while (iterator.hasNext()) {
                TableMetadata table;
                if (!(tableNamePattern == null ? table.getName() : tableNamePattern).equals((table = (TableMetadata)iterator.next()).getName())) continue;
                MetadataRow row = new MetadataRow().addEntry("TABLE_CAT", statement.connection.getCatalog()).addEntry("TABLE_SCHEM", keyspace.getName()).addEntry("TABLE_NAME", table.getName()).addEntry("TABLE_TYPE", TABLE_CONSTANT).addEntry("REMARKS", table.getOptions().getComment()).addEntry("TYPE_CAT", null).addEntry("TYPE_SCHEM", null).addEntry("TYPE_NAME", null).addEntry("SELF_REFERENCING_COL_NAME", null).addEntry("REF_GENERATION", null);
                schemas.add(row);
            }
        }
        CassandraMetadataResultSet result = new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(schemas));
        return result;
    }

    public CassandraMetadataResultSet makeColumns(CassandraStatement statement, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ArrayList schemas = Lists.newArrayList();
        List keyspaces = statement.connection.getClusterMetadata().getKeyspaces();
        for (KeyspaceMetadata keyspace : keyspaces) {
            if ("%".equals(schemaPattern)) {
                schemaPattern = null;
            }
            if (!(schemaPattern == null ? keyspace.getName() : schemaPattern).equals(keyspace.getName())) continue;
            Collection tables = keyspace.getTables();
            if ("%".equals(tableNamePattern)) {
                tableNamePattern = null;
            }
            Iterator iterator = tables.iterator();
            while (iterator.hasNext()) {
                TableMetadata table;
                if (!(tableNamePattern == null ? table.getName() : tableNamePattern).equals((table = (TableMetadata)iterator.next()).getName())) continue;
                List columns = table.getColumns();
                if ("%".equals(columnNamePattern)) {
                    columnNamePattern = null;
                }
                int columnIndex = 1;
                Iterator iterator2 = columns.iterator();
                while (iterator2.hasNext()) {
                    ColumnMetadata column;
                    if (!(columnNamePattern == null ? column.getName() : columnNamePattern).equals((column = (ColumnMetadata)iterator2.next()).getName())) continue;
                    int length = -1;
                    AbstractJdbcType<?> jtype = TypesMap.getTypeForComparator(column.getType().toString());
                    if (jtype instanceof JdbcBytes) {
                        length = 0x3FFFFFFF;
                    }
                    if (jtype instanceof JdbcAscii || jtype instanceof JdbcUTF8) {
                        length = Integer.MAX_VALUE;
                    }
                    if (jtype instanceof JdbcUUID) {
                        length = 36;
                    }
                    if (jtype instanceof JdbcInt32) {
                        length = 4;
                    }
                    if (jtype instanceof JdbcLong) {
                        length = 8;
                    }
                    int npr = 2;
                    if (jtype != null && (jtype.getJdbcType() == 3 || jtype.getJdbcType() == 2)) {
                        npr = 10;
                    }
                    Integer charol = null;
                    if (jtype instanceof JdbcAscii || jtype instanceof JdbcUTF8) {
                        charol = Integer.MAX_VALUE;
                    }
                    System.out.println("Type : " + column.getType().toString());
                    System.out.println("Name : " + column.getName());
                    int jdbcType = 1111;
                    try {
                        jdbcType = TypesMap.getTypeForComparator(column.getType().toString()).getJdbcType();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MetadataRow row = new MetadataRow().addEntry("TABLE_CAT", statement.connection.getCatalog()).addEntry("TABLE_SCHEM", keyspace.getName()).addEntry("TABLE_NAME", table.getName()).addEntry("COLUMN_NAME", column.getName()).addEntry("DATA_TYPE", jdbcType + "").addEntry("TYPE_NAME", column.getType().toString()).addEntry("COLUMN_SIZE", length + "").addEntry("BUFFER_LENGTH", "0").addEntry("DECIMAL_DIGITS", null).addEntry("NUM_PREC_RADIX", npr + "").addEntry("NULLABLE", "0").addEntry("REMARKS", column.toString()).addEntry("COLUMN_DEF", null).addEntry("SQL_DATA_TYPE", null).addEntry("SQL_DATETIME_SUB", null).addEntry("CHAR_OCTET_LENGTH", charol + "").addEntry("ORDINAL_POSITION", columnIndex + "").addEntry("IS_NULLABLE", "").addEntry("SCOPE_CATALOG", null).addEntry("SCOPE_SCHEMA", null).addEntry("SCOPE_TABLE", null).addEntry("SOURCE_DATA_TYPE", null).addEntry("IS_AUTOINCREMENT", "NO").addEntry("IS_GENERATEDCOLUMN", "NO");
                    schemas.add(row);
                    ++columnIndex;
                }
            }
        }
        CassandraMetadataResultSet result = new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(schemas));
        return result;
    }

    public CassandraMetadataResultSet makeIndexes(CassandraStatement statement, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        ArrayList schemas = Lists.newArrayList();
        List keyspaces = statement.connection.getClusterMetadata().getKeyspaces();
        for (KeyspaceMetadata keyspace : keyspaces) {
            if (!schema.equals(keyspace.getName())) continue;
            Collection tables = keyspace.getTables();
            for (TableMetadata table : tables) {
                if (!tableName.equals(table.getName())) continue;
                for (ColumnMetadata col : table.getColumns()) {
                    if (col.getIndex() == null) continue;
                    MetadataRow row = new MetadataRow().addEntry("TABLE_CAT", statement.connection.getCatalog()).addEntry("TABLE_SCHEM", keyspace.getName()).addEntry("TABLE_NAME", table.getName()).addEntry("NON_UNIQUE", "true").addEntry("INDEX_QUALIFIER", statement.connection.getCatalog()).addEntry("INDEX_NAME", col.getIndex().getName()).addEntry("TYPE", "2").addEntry("ORDINAL_POSITION", "1").addEntry("COLUMN_NAME", col.getName()).addEntry("ASC_OR_DESC", null).addEntry("CARDINALITY", "-1").addEntry("PAGES", "-1").addEntry("FILTER_CONDITION", null);
                    schemas.add(row);
                }
            }
        }
        CassandraMetadataResultSet result = new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(schemas));
        return result;
    }

    public CassandraMetadataResultSet makePrimaryKeys(CassandraStatement statement, String schema, String tableName) throws SQLException {
        ArrayList schemas = Lists.newArrayList();
        List keyspaces = statement.connection.getClusterMetadata().getKeyspaces();
        for (KeyspaceMetadata keyspace : keyspaces) {
            if (!schema.equals(keyspace.getName())) continue;
            Collection tables = keyspace.getTables();
            for (TableMetadata table : tables) {
                if (!tableName.equals(table.getName())) continue;
                int seq = 0;
                for (ColumnMetadata col : table.getPrimaryKey()) {
                    MetadataRow row = new MetadataRow().addEntry("TABLE_CAT", statement.connection.getCatalog()).addEntry("TABLE_SCHEM", keyspace.getName()).addEntry("TABLE_NAME", table.getName()).addEntry("COLUMN_NAME", col.getName()).addEntry("KEY_SEQ", seq + "").addEntry("PK_NAME", null);
                    schemas.add(row);
                    ++seq;
                }
            }
        }
        CassandraMetadataResultSet result = new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(schemas));
        return result;
    }
}

