/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.github.adejanovski.cassandra.jdbc.CassandraDataSource;
import com.github.adejanovski.cassandra.jdbc.ManagedConnection;
import com.github.adejanovski.cassandra.jdbc.PooledCassandraConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledCassandraDataSource
implements DataSource,
ConnectionEventListener {
    private static final int CONNECTION_IS_VALID_TIMEOUT = 5;
    private static final int MIN_POOL_SIZE = 4;
    protected static final String NOT_SUPPORTED = "the Cassandra implementation does not support this method";
    private static final Logger logger = LoggerFactory.getLogger(PooledCassandraDataSource.class);
    private CassandraDataSource connectionPoolDataSource;
    private volatile Set<PooledCassandraConnection> freeConnections = new HashSet<PooledCassandraConnection>();
    private volatile Set<PooledCassandraConnection> usedConnections = new HashSet<PooledCassandraConnection>();

    public PooledCassandraDataSource(CassandraDataSource connectionPoolDataSource) throws SQLException {
        this.connectionPoolDataSource = connectionPoolDataSource;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        PooledCassandraConnection pooledConnection;
        if (this.freeConnections.isEmpty()) {
            pooledConnection = this.connectionPoolDataSource.getPooledConnection();
            pooledConnection.addConnectionEventListener(this);
        } else {
            pooledConnection = this.freeConnections.iterator().next();
            this.freeConnections.remove(pooledConnection);
        }
        this.usedConnections.add(pooledConnection);
        return new ManagedConnection(pooledConnection);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException(NOT_SUPPORTED);
    }

    @Override
    public synchronized void connectionClosed(ConnectionEvent event) {
        PooledCassandraConnection connection = (PooledCassandraConnection)event.getSource();
        this.usedConnections.remove(connection);
        int freeConnectionsCount = this.freeConnections.size();
        if (freeConnectionsCount < 4) {
            this.freeConnections.add(connection);
        } else {
            try {
                connection.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage());
            }
        }
    }

    @Override
    public synchronized void connectionErrorOccurred(ConnectionEvent event) {
        PooledCassandraConnection connection = (PooledCassandraConnection)event.getSource();
        try {
            if (!connection.getConnection().isValid(5)) {
                connection.getConnection().close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        this.usedConnections.remove(connection);
    }

    public synchronized void close() {
        this.closePooledConnections(this.usedConnections);
        this.closePooledConnections(this.freeConnections);
    }

    private void closePooledConnections(Set<PooledCassandraConnection> usedConnections2) {
        for (PooledConnection pooledConnection : usedConnections2) {
            try {
                pooledConnection.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage());
            }
        }
    }

    @Override
    public int getLoginTimeout() {
        return this.connectionPoolDataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int secounds) {
        this.connectionPoolDataSource.setLoginTimeout(secounds);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.connectionPoolDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter writer) {
        this.connectionPoolDataSource.setLogWriter(writer);
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) {
        return this.connectionPoolDataSource.isWrapperFor(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return this.connectionPoolDataSource.unwrap(arg0);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.connectionPoolDataSource.getParentLogger();
    }
}

