/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.github.adejanovski.cassandra.jdbc.AbstractJdbcType;
import com.github.adejanovski.cassandra.jdbc.JdbcAscii;
import com.github.adejanovski.cassandra.jdbc.JdbcBoolean;
import com.github.adejanovski.cassandra.jdbc.JdbcBytes;
import com.github.adejanovski.cassandra.jdbc.JdbcCounterColumn;
import com.github.adejanovski.cassandra.jdbc.JdbcDate;
import com.github.adejanovski.cassandra.jdbc.JdbcDecimal;
import com.github.adejanovski.cassandra.jdbc.JdbcDouble;
import com.github.adejanovski.cassandra.jdbc.JdbcFloat;
import com.github.adejanovski.cassandra.jdbc.JdbcInetAddress;
import com.github.adejanovski.cassandra.jdbc.JdbcInt32;
import com.github.adejanovski.cassandra.jdbc.JdbcInteger;
import com.github.adejanovski.cassandra.jdbc.JdbcLexicalUUID;
import com.github.adejanovski.cassandra.jdbc.JdbcLong;
import com.github.adejanovski.cassandra.jdbc.JdbcOther;
import com.github.adejanovski.cassandra.jdbc.JdbcTimeUUID;
import com.github.adejanovski.cassandra.jdbc.JdbcTuple;
import com.github.adejanovski.cassandra.jdbc.JdbcUTF8;
import com.github.adejanovski.cassandra.jdbc.JdbcUUID;
import com.github.adejanovski.cassandra.jdbc.JdbcUdt;
import java.util.HashMap;
import java.util.Map;

public class TypesMap {
    private static final Map<String, AbstractJdbcType<?>> map = new HashMap();

    public static AbstractJdbcType<?> getTypeForComparator(String comparator) {
        if (comparator != null && !comparator.contains(".")) {
            if (map.containsKey("org.apache.cassandra.db.marshal." + comparator)) {
                return map.get("org.apache.cassandra.db.marshal." + comparator);
            }
            return JdbcOther.instance;
        }
        if (map.containsKey(comparator)) {
            return map.get(comparator);
        }
        return JdbcOther.instance;
    }

    static {
        map.put("org.apache.cassandra.db.marshal.AsciiType", JdbcAscii.instance);
        map.put("org.apache.cassandra.db.marshal.BooleanType", JdbcBoolean.instance);
        map.put("org.apache.cassandra.db.marshal.BytesType", JdbcBytes.instance);
        map.put("org.apache.cassandra.db.marshal.CounterColumnType", JdbcCounterColumn.instance);
        map.put("org.apache.cassandra.db.marshal.DateType", JdbcDate.instance);
        map.put("org.apache.cassandra.db.marshal.DecimalType", JdbcDecimal.instance);
        map.put("org.apache.cassandra.db.marshal.DoubleType", JdbcDouble.instance);
        map.put("org.apache.cassandra.db.marshal.FloatType", JdbcFloat.instance);
        map.put("org.apache.cassandra.db.marshal.Int32Type", JdbcInt32.instance);
        map.put("org.apache.cassandra.db.marshal.InetAddressType", JdbcInetAddress.instance);
        map.put("org.apache.cassandra.db.marshal.IntegerType", JdbcInteger.instance);
        map.put("org.apache.cassandra.db.marshal.LexicalUUIDType", JdbcLexicalUUID.instance);
        map.put("org.apache.cassandra.db.marshal.LongType", JdbcLong.instance);
        map.put("org.apache.cassandra.db.marshal.TimeUUIDType", JdbcTimeUUID.instance);
        map.put("org.apache.cassandra.db.marshal.UTF8Type", JdbcUTF8.instance);
        map.put("org.apache.cassandra.db.marshal.UUIDType", JdbcUUID.instance);
        map.put("org.apache.cassandra.db.marshal.ascii", JdbcAscii.instance);
        map.put("org.apache.cassandra.db.marshal.bigint", JdbcLong.instance);
        map.put("org.apache.cassandra.db.marshal.blob", JdbcBytes.instance);
        map.put("org.apache.cassandra.db.marshal.boolean", JdbcBoolean.instance);
        map.put("org.apache.cassandra.db.marshal.counter", JdbcLong.instance);
        map.put("org.apache.cassandra.db.marshal.decimal", JdbcDecimal.instance);
        map.put("org.apache.cassandra.db.marshal.double", JdbcDouble.instance);
        map.put("org.apache.cassandra.db.marshal.float", JdbcFloat.instance);
        map.put("org.apache.cassandra.db.marshal.inet", JdbcInetAddress.instance);
        map.put("org.apache.cassandra.db.marshal.int", JdbcInt32.instance);
        map.put("org.apache.cassandra.db.marshal.text", JdbcUTF8.instance);
        map.put("org.apache.cassandra.db.marshal.timestamp", JdbcDate.instance);
        map.put("org.apache.cassandra.db.marshal.uuid", JdbcUUID.instance);
        map.put("org.apache.cassandra.db.marshal.timeuuid", JdbcTimeUUID.instance);
        map.put("org.apache.cassandra.db.marshal.varchar", JdbcUTF8.instance);
        map.put("org.apache.cassandra.db.marshal.varint", JdbcInteger.instance);
        map.put("org.apache.cassandra.db.marshal.udt", JdbcUdt.instance);
        map.put("org.apache.cassandra.db.marshal.tuple", JdbcTuple.instance);
    }
}

