/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.persistence.bean;

import com.github.adminfaces.persistence.bean.BeanService;
import com.github.adminfaces.persistence.model.Filter;
import com.github.adminfaces.persistence.model.PersistenceEntity;
import com.github.adminfaces.persistence.service.CrudService;
import com.github.adminfaces.persistence.util.AdminDataModel;
import com.github.adminfaces.persistence.util.Messages;
import com.github.adminfaces.persistence.util.SessionFilter;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.provider.BeanProvider;

public abstract class CrudMB<T extends PersistenceEntity>
implements Serializable {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    protected CrudService<T, ? extends Serializable> crudService;
    protected T entity;
    protected Serializable id;
    protected Filter<T> filter;
    protected AdminDataModel<T> list;
    protected List<T> selectionList;
    protected T selection;
    protected List<T> filteredValue;
    @Inject
    protected SessionFilter sessionFilter;
    private String createMessage;
    private String removeMessage;
    private String updateMessage;

    @PostConstruct
    public void initCrudMB() {
        if (this.getCrudService() == null) {
            this.initServiceViaAnnotation();
            if (this.crudService == null) {
                this.log.log(Level.SEVERE, "You need to initialize CrudService on your Managed Bean and call setCrudService(yourService) or override getCrudService()");
                throw new RuntimeException("You need to initialize CrudService on your Managed Bean and call setCrudService(yourService) or override getCrudService()");
            }
        }
        this.entity = this.initEntity();
        this.filter = this.initFilter();
        this.list = new AdminDataModel<T>(this.crudService, this.filter);
    }

    private void initServiceViaAnnotation() {
        if (this.getClass().isAnnotationPresent(BeanService.class)) {
            BeanService beanService = this.getClass().getAnnotation(BeanService.class);
            Class<? extends CrudService> serviceClass = beanService.value();
            this.crudService = (CrudService)BeanProvider.getContextualReference(serviceClass, (Annotation[])new Annotation[0]);
        }
    }

    public void init() {
        if (FacesContext.getCurrentInstance().getPartialViewContext().isAjaxRequest()) {
            return;
        }
        if (this.id != null && !"".equals(this.id)) {
            this.entity = this.crudService.findById(this.id);
        }
    }

    protected Filter<T> initFilter() {
        Filter<Object> filter;
        if (this.keepFiltersInSession()) {
            String sessionFilterKey = this.getClass().getName();
            filter = this.sessionFilter.get(sessionFilterKey);
            if (filter == null) {
                filter = this.createDefaultFilters();
                this.sessionFilter.add(sessionFilterKey, filter);
            }
        } else {
            filter = this.createDefaultFilters();
        }
        return filter;
    }

    protected T initEntity() {
        return this.createDefaultEntity();
    }

    public boolean isNew() {
        return this.entity == null || this.entity.getId() == null;
    }

    public T createDefaultEntity() {
        try {
            return (T)((PersistenceEntity)((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]).newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.log.log(Level.SEVERE, String.format("Could not create entity class for bean %s", this.getClass().getName()), e);
            throw new RuntimeException(e);
        }
    }

    public Filter<T> createDefaultFilters() {
        return new Filter<T>(this.createDefaultEntity());
    }

    public boolean keepFiltersInSession() {
        return true;
    }

    public void setCrudService(CrudService<T, ?> crudService) {
        this.crudService = crudService;
    }

    public AdminDataModel<T> getList() {
        return this.list;
    }

    public void setList(AdminDataModel<T> list) {
        this.list = list;
    }

    public List<T> getSelectionList() {
        return this.selectionList;
    }

    public void setSelectionList(List<T> selectionList) {
        this.selectionList = selectionList;
    }

    public T getSelection() {
        return this.selection;
    }

    public void setSelection(T selection) {
        this.selection = selection;
    }

    public List<T> getFilteredValue() {
        return this.filteredValue;
    }

    public void setFilteredValue(List<T> filteredValue) {
        this.filteredValue = filteredValue;
    }

    public T getEntity() {
        return this.entity;
    }

    public void setEntity(T entity) {
        this.entity = entity;
    }

    public Filter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(Filter<T> filter) {
        this.filter = filter;
    }

    public CrudService<T, ?> getCrudService() {
        return this.crudService;
    }

    public Serializable getId() {
        return this.id;
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    public String getCreateMessage() {
        if (this.createMessage == null) {
            this.createMessage = "Record created successfully";
        }
        return this.createMessage;
    }

    public String getRemoveMessage() {
        if (this.removeMessage == null) {
            this.removeMessage = "Record removed successfully";
        }
        return this.removeMessage;
    }

    public String getUpdateMessage() {
        if (this.updateMessage == null) {
            this.updateMessage = "Record updated successfully";
        }
        return this.updateMessage;
    }

    public T save() {
        if (this.isNew()) {
            this.beforeInsert();
            this.crudService.insert(this.entity);
            this.afterInsert();
        } else {
            this.beforeUpdate();
            this.entity = this.crudService.update(this.entity);
            this.afterUpdate();
        }
        return this.entity;
    }

    public void remove() {
        this.beforeRemove();
        this.crudService.remove(this.entity);
        this.afterRemove();
    }

    public void clear() {
        if (this.keepFiltersInSession()) {
            this.sessionFilter.clear(this.getClass().getName());
        }
        this.filter = this.initFilter();
        this.list.setFilter(this.filter);
        this.entity = this.initEntity();
        this.id = null;
    }

    public void beforeRemove() {
    }

    public void afterRemove() {
        CrudMB.addDetailMsg(this.getRemoveMessage());
    }

    public void beforeInsert() {
    }

    public void afterInsert() {
        CrudMB.addDetailMsg(this.getCreateMessage());
    }

    public void beforeUpdate() {
    }

    public void afterUpdate() {
        CrudMB.addDetailMsg(this.getUpdateMessage());
    }

    public static void addDetailMsg(String message) {
        Messages.addDetailMessage(message);
    }

    public static void addDetailMsg(String message, FacesMessage.Severity severity) {
        Messages.addDetailMessage(message, severity);
    }
}

