/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.persistence.converter;

import com.github.adminfaces.persistence.model.PersistenceEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

@FacesConverter(forClass=PersistenceEntity.class, value="entityConverter")
public class EntityConverter
implements Converter {
    public String getAsString(FacesContext context, UIComponent component, Object entity) {
        if (entity == null || "".equals(entity)) {
            return null;
        }
        if (!this.getEntityMap(context).containsKey(entity)) {
            String uuid = UUID.randomUUID().toString();
            this.getEntityMap(context).put(entity, uuid);
            return uuid;
        }
        return this.getEntityMap(context).get(entity);
    }

    public Object getAsObject(FacesContext context, UIComponent component, String uuid) {
        Set<Map.Entry<Object, String>> entries = this.getEntityMap(context).entrySet();
        for (Map.Entry<Object, String> entry : entries) {
            if (!entry.getValue().equals(uuid)) continue;
            return entry.getKey();
        }
        return null;
    }

    private Map<Object, String> getEntityMap(FacesContext context) {
        Map viewMap = context.getViewRoot().getViewMap();
        HashMap entities = (HashMap)viewMap.get("entities");
        if (entities == null) {
            entities = new HashMap();
            viewMap.put("entities", entities);
        }
        return entities;
    }
}

