/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.persistence.service;

import com.github.adminfaces.persistence.model.AdminSort;
import com.github.adminfaces.persistence.model.Filter;
import com.github.adminfaces.persistence.model.PersistenceEntity;
import com.github.adminfaces.persistence.service.Service;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.deltaspike.data.api.criteria.Criteria;
import org.apache.deltaspike.data.api.criteria.CriteriaSupport;
import org.apache.deltaspike.data.api.criteria.QuerySelection;
import org.apache.deltaspike.data.impl.handler.CriteriaSupportHandler;

@Service
public class CrudService<T extends PersistenceEntity, PK extends Serializable>
extends CriteriaSupportHandler<T>
implements CriteriaSupport<T>,
Serializable {
    private static final Logger LOG = Logger.getLogger(CrudService.class.getName());
    protected Class<T> entityClass;
    protected Class<PK> entityKey;
    @Inject
    protected EntityManager entityManager;

    @Inject
    protected void CrudService(InjectionPoint ip) {
        if (ip != null && ip.getType() != null && ip.getMember() != null) {
            try {
                this.resolveEntity(ip);
            }
            catch (Exception e) {
                LOG.warning(String.format("Could not resolve entity type and entity key via injection point [%s]. Now trying to resolve via generic superclass of [%s].", ip.getMember().getName(), this.getClass().getName()));
            }
        }
        if (this.entityClass == null) {
            this.entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.entityKey = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        }
    }

    private void resolveEntity(InjectionPoint ip) {
        ParameterizedType type = (ParameterizedType)ip.getType();
        Type[] typeArgs = type.getActualTypeArguments();
        this.entityClass = (Class)typeArgs[0];
        this.entityKey = (Class)typeArgs[1];
    }

    public List<T> paginate(Filter<T> filter) {
        Criteria<T, T> criteria = this.configRestrictions(filter);
        String sortField = filter.getSortField();
        if (sortField != null) {
            SingularAttribute sortAttribute = this.entityManager.getMetamodel().entity(this.entityClass).getSingularAttribute(sortField);
            if (filter.getAdminSort().equals((Object)AdminSort.UNSORTED)) {
                filter.setAdminSort(AdminSort.ASCENDING);
            }
            if (filter.getAdminSort().equals((Object)AdminSort.ASCENDING)) {
                criteria.orderAsc(sortAttribute);
            } else {
                criteria.orderDesc(sortAttribute);
            }
        }
        return criteria.createQuery().setFirstResult(filter.getFirst()).setMaxResults(filter.getPageSize()).getResultList();
    }

    protected Criteria<T, T> configRestrictions(Filter<T> filter) {
        return this.criteria();
    }

    public void insert(T entity) {
        if (entity == null) {
            throw new RuntimeException("Record cannot be null");
        }
        this.beforeInsert(entity);
        this.entityManager.persist(entity);
        this.afterInsert(entity);
    }

    public void remove(T entity) {
        if (entity == null) {
            throw new RuntimeException("Record cannot be null");
        }
        if (entity.getId() == null) {
            throw new RuntimeException("Record cannot be transient");
        }
        this.beforeRemove(entity);
        if (!this.entityManager.contains(entity)) {
            entity = (PersistenceEntity)this.entityManager.find(this.entityClass, entity.getId());
        }
        this.entityManager.remove(entity);
        this.afterRemove(entity);
    }

    public void remove(List<T> entities) {
        if (entities == null) {
            throw new RuntimeException("Entities cannot be null");
        }
        for (PersistenceEntity t : entities) {
            this.remove(t);
        }
    }

    public T update(T entity) {
        if (entity == null) {
            throw new RuntimeException("Record cannot be null");
        }
        if (entity.getId() == null) {
            throw new RuntimeException("Record cannot be transient");
        }
        this.beforeUpdate(entity);
        entity = (PersistenceEntity)this.entityManager.merge(entity);
        this.entityManager.flush();
        this.afterUpdate(entity);
        return entity;
    }

    public T saveOrUpdate(T entity) {
        if (entity == null) {
            throw new RuntimeException("Record cannot be null");
        }
        if (entity.getId() == null) {
            this.insert(entity);
        } else {
            entity = this.update(entity);
        }
        return entity;
    }

    public Long count() {
        return this.count(this.criteria());
    }

    public Long count(Filter<T> filter) {
        return this.count(this.configRestrictions(filter));
    }

    public Long count(Criteria<T, T> criteria) {
        SingularAttribute id = this.getEntityManager().getMetamodel().entity(this.entityClass).getId(this.entityKey);
        return (Long)criteria.select(Long.class, new QuerySelection[]{this.countDistinct(id)}).getSingleResult();
    }

    public T findById(Serializable id) {
        PersistenceEntity entity = (PersistenceEntity)this.entityManager.find(this.entityClass, (Object)id);
        if (entity == null) {
            LOG.warning(String.format("Record with id %s not found for entity %s.", id, this.entityClass.getName()));
        }
        return (T)entity;
    }

    public Criteria example(T example, Attribute<T, ?> ... usingAttributes) {
        return this.example(this.criteria(), example, usingAttributes);
    }

    public Criteria example(Criteria criteria, T example, Attribute<T, ?> ... usingAttributes) {
        if (criteria == null) {
            criteria = this.criteria();
        }
        if (usingAttributes == null || usingAttributes.length == 0) {
            throw new RuntimeException("Please provide attributes to example criteria.");
        }
        for (Attribute<T, ?> usingAttribute : usingAttributes) {
            if (usingAttribute instanceof SingularAttribute) {
                this.addEqExampleRestriction(criteria, example, usingAttribute);
                continue;
            }
            if (!(usingAttribute instanceof PluralAttribute)) continue;
            this.addInExampleRestriction(criteria, example, usingAttribute);
        }
        return criteria;
    }

    private void addEqExampleRestriction(Criteria criteria, T example, Attribute<T, ?> attribute) {
        if (attribute.getJavaMember() instanceof Field) {
            Field field = (Field)attribute.getJavaMember();
            field.setAccessible(true);
            try {
                Object value = field.get(example);
                if (value != null) {
                    LOG.fine(String.format("Adding an 'eq' restriction on attribute %s using value %s.", attribute.getName(), value));
                    criteria.eq((SingularAttribute)attribute, value);
                }
            }
            catch (IllegalAccessException e) {
                LOG.warning(String.format("Could not get value from field %s of entity %s.", field.getName(), example.getClass().getName()));
            }
        }
    }

    private void addInExampleRestriction(Criteria criteria, T example, Attribute<T, ?> attribute) {
        PluralAttribute listAttribute = (PluralAttribute)attribute;
        Class joinClass = listAttribute.getElementType().getJavaType();
        Criteria joinCriteria = this.where(joinClass, JoinType.LEFT);
        if (listAttribute instanceof ListAttribute) {
            criteria.join((ListAttribute)listAttribute, joinCriteria);
        } else if (listAttribute instanceof SetAttribute) {
            criteria.join((SetAttribute)listAttribute, joinCriteria);
        } else if (listAttribute instanceof MapAttribute) {
            criteria.join((MapAttribute)listAttribute, joinCriteria);
        } else if (listAttribute instanceof CollectionAttribute) {
            criteria.join((CollectionAttribute)listAttribute, joinCriteria);
        }
        if (attribute.getJavaMember() instanceof Field) {
            Field field = (Field)attribute.getJavaMember();
            field.setAccessible(true);
            try {
                Object value = field.get(example);
                if (value != null) {
                    LOG.fine(String.format("Adding an \u00edn'restriction on attribute %s using value %s.", attribute.getName(), value));
                    Collection association = (Collection)value;
                    SingularAttribute id = this.getEntityManager().getMetamodel().entity(listAttribute.getElementType().getJavaType()).getId(((PersistenceEntity)association.iterator().next()).getId().getClass());
                    ArrayList ids = new ArrayList();
                    for (PersistenceEntity persistenceEntity : association) {
                        ids.add(persistenceEntity.getId());
                    }
                    joinCriteria.in(id, new Object[]{ids});
                }
            }
            catch (IllegalAccessException e) {
                LOG.warning(String.format("Could not get value from field %s of entity %s.", field.getName(), example.getClass().getName()));
            }
        }
    }

    public Criteria exampleLike(T example, SingularAttribute<T, String> ... usingAttributes) {
        return this.exampleLike(this.criteria(), example, usingAttributes);
    }

    public Criteria exampleLike(Criteria criteria, T example, SingularAttribute<T, String> ... usingAttributes) {
        if (usingAttributes == null || usingAttributes.length == 0) {
            throw new RuntimeException("Please provide attributes to example criteria.");
        }
        if (criteria == null) {
            criteria = this.criteria();
        }
        for (SingularAttribute<T, String> attribute : usingAttributes) {
            if (!(attribute.getJavaMember() instanceof Field)) continue;
            Field field = (Field)attribute.getJavaMember();
            field.setAccessible(true);
            try {
                Object value = field.get(example);
                if (value == null) continue;
                LOG.fine(String.format("Adding restriction by example on attribute %s using value %s.", attribute.getName(), value));
                criteria.likeIgnoreCase(attribute, value.toString());
            }
            catch (IllegalAccessException e) {
                LOG.warning(String.format("Could not get value from field %s of entity %s.", field.getName(), example.getClass().getName()));
            }
        }
        return criteria;
    }

    public Class<PK> getEntityKey() {
        return this.entityKey;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void beforeInsert(T entity) {
    }

    public void afterInsert(T entity) {
    }

    public void beforeUpdate(T entity) {
    }

    public void afterUpdate(T entity) {
    }

    public void beforeRemove(T entity) {
    }

    public void afterRemove(T entity) {
    }
}

