/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.clusteredobjectpool.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Future;
import org.bbottema.clusteredobjectpool.core.ResourcePool;
import org.bbottema.clusteredobjectpool.util.CompositeFuturesAsFutureTask;
import org.bbottema.genericobjectpool.PoolableObject;
import org.bbottema.genericobjectpool.util.Timeout;
import org.jetbrains.annotations.Nullable;

class ResourcePools<PoolKey, T> {
    private final Collection<ResourcePool<PoolKey, T>> clusterCollection;
    private final Collection<ResourcePool<PoolKey, T>> poolsShuttingDown;

    Future<Void> shutdownPool(@Nullable PoolKey key) {
        ArrayList<Future<Void>> poolsShuttingDownFuture = new ArrayList<Future<Void>>();
        Iterator<ResourcePool<PoolKey, T>> iterator = this.clusterCollection.iterator();
        while (iterator.hasNext()) {
            ResourcePool<PoolKey, T> poolInCluster = iterator.next();
            if (key != null && !poolInCluster.getPoolKey().equals(key)) continue;
            poolsShuttingDownFuture.add(poolInCluster.clearPool());
            this.poolsShuttingDown.add(poolInCluster);
            iterator.remove();
        }
        Future<Void> future = CompositeFuturesAsFutureTask.ofFutures(poolsShuttingDownFuture);
        if (future == null) {
            throw new IllegalStateException("NotNull method org/bbottema/clusteredobjectpool/core/ResourcePools.shutdownPool must not return null");
        }
        return future;
    }

    boolean containsPool(PoolKey poolKey) {
        if (poolKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourcePools.containsPool must not be null");
        }
        return this.findResourcePool(poolKey) != null;
    }

    void add(ResourcePool<PoolKey, T> resourcePool) {
        if (resourcePool == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourcePools.add must not be null");
        }
        this.clusterCollection.add(resourcePool);
    }

    @Nullable
    PoolableObject<T> claimResource(PoolKey poolKey, Timeout claimTimeout) throws InterruptedException {
        if (poolKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourcePools.claimResource must not be null");
        }
        if (claimTimeout == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/clusteredobjectpool/core/ResourcePools.claimResource must not be null");
        }
        ResourcePool<PoolKey, T> resourcePool = this.findResourcePool(poolKey);
        if (resourcePool == null) {
            throw new IllegalArgumentException("Couldn't find resource pool with key: " + poolKey);
        }
        return resourcePool.claim(claimTimeout);
    }

    @Nullable
    private ResourcePool<PoolKey, T> findResourcePool(PoolKey poolKey) {
        if (poolKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourcePools.findResourcePool must not be null");
        }
        for (ResourcePool<PoolKey, T> resourcePool : this.clusterCollection) {
            if (!resourcePool.getPoolKey().equals(poolKey)) continue;
            return resourcePool;
        }
        return null;
    }

    int currentlyAllocated() {
        int total = 0;
        for (ResourcePool<PoolKey, T> resourcePool : this.clusterCollection) {
            total += resourcePool.getPoolMetrics().getCurrentlyAllocated();
        }
        for (ResourcePool<PoolKey, T> resourcePool : this.poolsShuttingDown) {
            total += resourcePool.getPoolMetrics().getCurrentlyAllocated();
        }
        return total;
    }

    public ResourcePools(Collection<ResourcePool<PoolKey, T>> clusterCollection) {
        if (clusterCollection == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourcePools.<init> must not be null");
        }
        this.poolsShuttingDown = new ArrayList<ResourcePool<PoolKey, T>>();
        this.clusterCollection = clusterCollection;
    }

    public String toString() {
        String string = "ResourcePools(clusterCollection=" + this.getClusterCollection() + ", poolsShuttingDown=" + this.poolsShuttingDown + ")";
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/clusteredobjectpool/core/ResourcePools.toString must not return null");
        }
        return string;
    }

    Collection<ResourcePool<PoolKey, T>> getClusterCollection() {
        Collection<ResourcePool<PoolKey, T>> collection = this.clusterCollection;
        if (collection == null) {
            throw new IllegalStateException("NotNull method org/bbottema/clusteredobjectpool/core/ResourcePools.getClusterCollection must not return null");
        }
        return collection;
    }
}

