/*
 * Decompiled with CFR 0.152.
 */
package threegpp.charset;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import threegpp.charset.TelecomCharset;
import threegpp.charset.gsm.GSM7BitPackedCharset;
import threegpp.charset.gsm.GSMCharset;
import threegpp.charset.ucs2.UCS2Charset80;
import threegpp.charset.ucs2.UCS2Charset81;

public class CharsetProvider
extends java.nio.charset.spi.CharsetProvider {
    private static Charset[] allCharsets = new Charset[]{new GSM7BitPackedCharset(), new GSMCharset(), new UCS2Charset80(), new UCS2Charset81(), new TelecomCharset()};
    private Set<Charset> set = new HashSet<Charset>();
    private Map<String, Charset> namesMap = new HashMap<String, Charset>();

    public CharsetProvider() {
        Collections.addAll(this.set, allCharsets);
        for (Charset cs : allCharsets) {
            this.namesMap.put(cs.displayName(), cs);
            for (String alias : cs.aliases()) {
                this.namesMap.put(alias, cs);
            }
        }
    }

    @Override
    public Iterator<Charset> charsets() {
        return this.set.iterator();
    }

    @Override
    public Charset charsetForName(String charsetName) {
        return this.namesMap.get(charsetName);
    }
}

