/*
 * Decompiled with CFR 0.152.
 */
package threegpp.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import threegpp.charset.Util;
import threegpp.charset.gsm.GSMCharset;
import threegpp.charset.ucs2.UCS2Charset80;
import threegpp.charset.ucs2.UCS2Charset81;

public class TelecomCharsetDecoder
extends CharsetDecoder {
    private static final float AVERAGE_CHARS_PER_BYTE = 0.5f;
    private static final float MAX_CHARS_PER_BYTE = 1.0f;
    private Charset currentCharset;
    private CharsetDecoder currentDecoder;

    TelecomCharsetDecoder(Charset cs) {
        super(cs, 0.5f, 1.0f);
    }

    @Override
    protected CoderResult implFlush(CharBuffer out) {
        this.currentDecoder.decode(ByteBuffer.allocate(0), out, true);
        return this.currentDecoder.flush(out);
    }

    @Override
    protected void implReset() {
        this.currentCharset = null;
        this.currentDecoder = null;
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        if (null == this.currentCharset) {
            if (!in.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            CoderResult cr = this.createDecoder(in);
            if (!cr.isUnderflow()) {
                return cr;
            }
        }
        return this.currentDecoder.decode(in, out, false);
    }

    @Override
    public boolean isAutoDetecting() {
        return true;
    }

    @Override
    public boolean isCharsetDetected() {
        return null != this.currentCharset;
    }

    @Override
    public Charset detectedCharset() {
        if (!this.isCharsetDetected()) {
            throw new IllegalStateException();
        }
        return this.currentCharset;
    }

    private static Charset detectCharset(int firstByte) {
        int unsignedByte = Util.keepUnsigned(firstByte);
        if ((unsignedByte & 0x80) == 0) {
            return new GSMCharset();
        }
        if (unsignedByte == UCS2Charset80.CHARSET_TAG) {
            return new UCS2Charset80();
        }
        if (unsignedByte == 129) {
            return new UCS2Charset81();
        }
        return null;
    }

    private CoderResult createDecoder(ByteBuffer in) {
        this.currentCharset = TelecomCharsetDecoder.detectCharset(in.get());
        if (null == this.currentCharset) {
            return CoderResult.malformedForLength(in.remaining() + 1);
        }
        this.currentDecoder = this.currentCharset.newDecoder();
        in.position(in.position() - 1);
        return CoderResult.UNDERFLOW;
    }
}

