/*
 * Decompiled with CFR 0.152.
 */
package threegpp.charset.gsm;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import threegpp.charset.Util;
import threegpp.charset.gsm.GSM7BitPackedCharset;

public class GSM7BitPackedDecoder
extends CharsetDecoder {
    private static final float AVG_CHARS_PER_BYTE = 1.1428572f;
    private static final float MAX_CHARS_PER_BYTE = 1.1428572f;
    private Unpacker7Bit unpacker;
    private ByteBuffer unpacked7Bit;
    private CharsetDecoder decoder = GSM7BitPackedCharset.underlyingCharset.newDecoder();

    GSM7BitPackedDecoder(GSM7BitPackedCharset cs) {
        super(cs, 1.1428572f, 1.1428572f);
    }

    @Override
    protected CoderResult implFlush(CharBuffer out) {
        if (out.hasRemaining()) {
            if (null == this.unpacked7Bit) {
                this.unpacked7Bit = this.unpacker.getDecodedBytes();
            }
            return this.decoder.decode(this.unpacked7Bit, out, true);
        }
        return CoderResult.OVERFLOW;
    }

    @Override
    protected void implReset() {
        this.decoder.reset();
        this.unpacked7Bit = null;
        this.unpacker = null;
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (in.hasRemaining()) {
            if (null == this.unpacker) {
                this.unpacker = new Unpacker7Bit(in.remaining());
            }
            this.unpacker.decode(in);
        }
        return CoderResult.UNDERFLOW;
    }

    private static class DecodingCycleStepsIterator {
        private static final int[] leftShifts = new int[]{7, 0, 1, 2, 3, 4, 5, 6};
        private static final int[] rightShifts = new int[]{0, 7, 6, 5, 4, 3, 2, 1};
        private static final int[] masks = new int[]{0, 127, 63, 31, 15, 7, 3, 1};
        private int pos = 0;

        private DecodingCycleStepsIterator() {
        }

        DecodingStepParameters next() {
            if (this.pos == leftShifts.length) {
                this.pos = 0;
            }
            return new DecodingStepParameters(leftShifts[this.pos], rightShifts[this.pos], masks[this.pos++]);
        }
    }

    private static class DecodingStepParameters {
        private static int neutralRightShift = 0;
        private final int leftShift;
        private final int rightShift;
        private final int mask;

        DecodingStepParameters(int leftShift, int rightShift, int mask) {
            this.leftShift = leftShift;
            this.rightShift = rightShift;
            this.mask = mask;
        }

        int getLeftShift() {
            return this.leftShift;
        }

        int getRightShift() {
            return this.rightShift;
        }

        int getMask() {
            return this.mask;
        }

        boolean isReinitStep() {
            return this.rightShift == neutralRightShift;
        }
    }

    private static class Unpacker7Bit {
        private final ByteArrayOutputStream decodedFrom7Bit;
        private final DecodingCycleStepsIterator stepsIterator = new DecodingCycleStepsIterator();
        private int tailFromPrevStep;
        private boolean tailInitialized = false;

        Unpacker7Bit(int initialSize) {
            this.decodedFrom7Bit = new ByteArrayOutputStream(initialSize);
        }

        void decode(ByteBuffer in) {
            while (in.hasRemaining()) {
                DecodingStepParameters stepParameters = this.stepsIterator.next();
                if (stepParameters.isReinitStep()) {
                    this.reinit();
                    continue;
                }
                int inputByte = Util.keepUnsigned(in.get());
                int head = (inputByte & stepParameters.getMask()) << stepParameters.getLeftShift();
                int result = this.haveTail() ? head | this.tailFromPrevStep : head;
                this.decodedFrom7Bit.write(result);
                this.tailFromPrevStep = inputByte >> stepParameters.getRightShift();
                this.tailInitialized = true;
            }
        }

        ByteBuffer getDecodedBytes() {
            if (this.haveTail() && this.tailHaveToBeKept()) {
                this.decodedFrom7Bit.write(this.tailFromPrevStep);
            }
            return ByteBuffer.wrap(this.decodedFrom7Bit.toByteArray());
        }

        private void reinit() {
            if (this.decodedFrom7Bit.size() > 0) {
                this.decodedFrom7Bit.write(this.tailFromPrevStep);
            }
            this.tailInitialized = false;
        }

        private boolean haveTail() {
            return this.tailInitialized;
        }

        private boolean tailHaveToBeKept() {
            return this.tailFromPrevStep != 0;
        }
    }
}

