/*
 * Decompiled with CFR 0.152.
 */
package threegpp.charset.gsm;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.NoSuchElementException;
import threegpp.charset.Util;
import threegpp.charset.gsm.GSM7BitPackedCharset;

public class GSM7BitPackedEncoder
extends CharsetEncoder {
    private static final float AVERAGE_BYTES_PER_CHAR = 0.875f;
    private static final float MAX_BYTES_PER_CHAR = 2.0f;
    private CharsetEncoder encoder = GSM7BitPackedCharset.underlyingCharset.newEncoder();
    private ByteSaver byteSaver = null;
    private BytePacker bytePacker = null;

    GSM7BitPackedEncoder(GSM7BitPackedCharset cs) {
        super(cs, 0.875f, 2.0f);
    }

    @Override
    protected CoderResult implFlush(ByteBuffer out) {
        if (null == this.bytePacker) {
            CoderResult result = this.byteSaver.flush(this.encoder);
            if (!result.isUnderflow()) {
                return result;
            }
            this.bytePacker = new BytePacker(this.byteSaver.iterator());
        }
        return this.bytePacker.packBytes(out);
    }

    @Override
    protected void implReset() {
        this.encoder.reset();
        this.byteSaver = null;
        this.bytePacker = null;
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        if (null == this.byteSaver) {
            this.byteSaver = new ByteSaver(in.remaining());
        }
        return this.byteSaver.encode(in, this.encoder);
    }

    @Override
    public boolean canEncode(char c) {
        return this.encoder.canEncode(c);
    }

    @Override
    public boolean canEncode(CharSequence cs) {
        return this.encoder.canEncode(cs);
    }

    private static class IntIterator {
        private byte[] bytes;
        private int pos = 0;

        IntIterator(byte[] bytes) {
            if (null == bytes) {
                throw new IllegalArgumentException();
            }
            this.bytes = bytes;
        }

        boolean hasNext() {
            return this.bytes.length != 0 && this.pos != this.bytes.length;
        }

        int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.bytes[this.pos++];
        }
    }

    private static class EncodingCycleStepsIterator {
        private final int[] rShifts = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        private final int[] lShifts = new int[]{7, 6, 5, 4, 3, 2, 1, 0};
        int pos = 0;

        private EncodingCycleStepsIterator() {
        }

        EncodingStepParameters next() {
            if (this.pos == this.rShifts.length) {
                this.pos = 0;
            }
            return new EncodingStepParameters(this.rShifts[this.pos], this.lShifts[this.pos++]);
        }
    }

    private static class EncodingStepParameters {
        private final int SKIP_STEP_NUM = 7;
        int rightShift;
        int leftShift;

        EncodingStepParameters(int rShift, int lShift) {
            this.rightShift = rShift;
            this.leftShift = lShift;
        }

        int getRightShift() {
            return this.rightShift;
        }

        int getLeftShift() {
            return this.leftShift;
        }

        boolean shouldBeDone() {
            return this.rightShift != 7;
        }
    }

    private static class ShiftedIntPairIterator {
        private IntIterator iterator;
        private int first;
        private int second;
        private boolean initial = true;
        private boolean stop = false;

        ShiftedIntPairIterator(IntIterator iterator) {
            this.iterator = iterator;
        }

        boolean hasNext() {
            return !this.stop;
        }

        IntPair next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.initial) {
                this.first = this.iterator.next();
                this.initial = false;
            } else {
                this.first = this.second;
            }
            if (this.iterator.hasNext()) {
                this.second = this.iterator.next();
            } else {
                this.second = 0;
                this.stop = true;
            }
            return new IntPair(this.first, this.second);
        }
    }

    private static class IntPair {
        private int first;
        private int second;

        IntPair(int f, int s) {
            this.first = f;
            this.second = s;
        }

        int getFirst() {
            return this.first;
        }

        int getSecond() {
            return this.second;
        }
    }

    private static class BytePacker {
        private ShiftedIntPairIterator iterator;
        private EncodingCycleStepsIterator stepsIterator = new EncodingCycleStepsIterator();
        private EncodingStepParameters currentStep;

        BytePacker(ShiftedIntPairIterator iterator) {
            this.iterator = iterator;
        }

        CoderResult packBytes(ByteBuffer out) {
            while (this.iterator.hasNext()) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                IntPair pair = this.iterator.next();
                this.currentStep = this.stepsIterator.next();
                if (!this.currentStep.shouldBeDone()) continue;
                out.put(this.pack(pair, this.currentStep));
            }
            return CoderResult.UNDERFLOW;
        }

        int getNumberOfUsedBitsInLastByte() {
            return this.currentStep.getLeftShift();
        }

        private byte pack(IntPair bytes, EncodingStepParameters parameters) {
            int half1 = bytes.getFirst() >> parameters.getRightShift();
            int half2 = bytes.getSecond() << parameters.getLeftShift();
            return (byte)Util.keepUnsigned(half1 | half2);
        }
    }

    private static class ByteStore {
        private ByteArrayOutputStream store;
        private byte[] bufferBackend;
        private ByteBuffer buffer;

        ByteStore(int size) {
            this.store = new ByteArrayOutputStream(size);
            this.bufferBackend = new byte[size];
            this.buffer = ByteBuffer.wrap(this.bufferBackend);
        }

        ByteBuffer asByteBuffer() {
            return this.buffer;
        }

        void flush() {
            this.store.write(this.bufferBackend, 0, this.buffer.position());
            this.buffer.rewind();
        }

        byte[] getResultArray() {
            return this.store.toByteArray();
        }
    }

    private static class ByteSaver {
        private static final float INCREASE_THRESHOLD = 1.1f;
        private ByteStore store;

        ByteSaver(int size) {
            this.store = new ByteStore(ByteSaver.withThreshold(size));
        }

        ShiftedIntPairIterator iterator() {
            return new ShiftedIntPairIterator(new IntIterator(this.store.getResultArray()));
        }

        CoderResult encode(CharBuffer in, CharsetEncoder encoder) {
            CoderResult result = encoder.encode(in, this.store.asByteBuffer(), false);
            this.store.flush();
            while (result.isOverflow()) {
                result = encoder.encode(in, this.store.asByteBuffer(), false);
                this.store.flush();
            }
            return result;
        }

        CoderResult flush(CharsetEncoder encoder) {
            CoderResult result = encoder.encode(CharBuffer.wrap(""), this.store.asByteBuffer(), true);
            this.store.flush();
            if (!result.isUnderflow()) {
                return result;
            }
            result = encoder.flush(this.store.asByteBuffer());
            this.store.flush();
            while (result.isOverflow()) {
                result = encoder.flush(this.store.asByteBuffer());
                this.store.flush();
            }
            return result;
        }

        private static int withThreshold(int val) {
            return (int)((float)val * 1.1f);
        }
    }
}

