/*
 * Decompiled with CFR 0.152.
 */
package threegpp.charset.ucs2;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import threegpp.charset.Util;
import threegpp.charset.ucs2.UCS2Charset81;

public class UCS2Decoder81
extends CharsetDecoder {
    private static float MAX_CHARS_PER_BYTE = 1.0f;
    private static float AVERAGE_CHARS_PER_BYTE = 1.0f;
    private static int MIN_VALID_INPUT_BUFFER_LENGTH = 4;
    private static int MIN_CHAR_COUNT = 1;
    private int numCharactersExpected = 0;
    private int charNum = 0;
    private int halfPagePointer = 0;

    UCS2Decoder81(UCS2Charset81 cs) {
        super(cs, AVERAGE_CHARS_PER_BYTE, MAX_CHARS_PER_BYTE);
    }

    @Override
    public CodingErrorAction malformedInputAction() {
        return CodingErrorAction.REPORT;
    }

    @Override
    public CodingErrorAction unmappableCharacterAction() {
        return CodingErrorAction.REPORT;
    }

    @Override
    protected void implReset() {
        this.numCharactersExpected = 0;
        this.charNum = 0;
        this.halfPagePointer = 0;
    }

    @Override
    protected CoderResult implFlush(CharBuffer out) {
        if (this.charNum == this.numCharactersExpected) {
            return CoderResult.UNDERFLOW;
        }
        return CoderResult.malformedForLength(this.numCharactersExpected);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        if (this.onStartOfDecoding()) {
            if (!UCS2Decoder81.isInputBufferInitiallyValid(in)) {
                return CoderResult.malformedForLength(1);
            }
            this.setUpDecoderAdvancingBuffer(in);
        }
        while (in.hasRemaining() && this.charNum <= this.numCharactersExpected) {
            if (out.hasRemaining()) {
                out.put(this.inputByteToChar(in.get()));
                ++this.charNum;
                continue;
            }
            return CoderResult.OVERFLOW;
        }
        return CoderResult.UNDERFLOW;
    }

    private static boolean isInputBufferInitiallyValid(ByteBuffer in) {
        if (in.limit() >= MIN_VALID_INPUT_BUFFER_LENGTH && in.get() == -127) {
            byte length = in.get();
            in.position(in.position() - 1);
            return length >= MIN_CHAR_COUNT;
        }
        return false;
    }

    private static int getCodePageAsInt(byte codePage) {
        return codePage << 7;
    }

    private boolean isHalfPageOffsetRequired(int value) {
        return (value & 0x80) != 0;
    }

    private int remove7thBit(int value) {
        return value ^ 0x80;
    }

    private char makeCharWithPageOffset(int value) {
        return (char)(this.halfPagePointer | this.remove7thBit(value));
    }

    private char makeCharWithNoPage(int value) {
        return (char)value;
    }

    private char inputByteToChar(byte value) {
        int unsignedValue = Util.keepUnsigned(value);
        return this.isHalfPageOffsetRequired(unsignedValue) ? this.makeCharWithPageOffset(unsignedValue) : this.makeCharWithNoPage(unsignedValue);
    }

    private boolean onStartOfDecoding() {
        return this.numCharactersExpected == 0;
    }

    private void setUpDecoderAdvancingBuffer(ByteBuffer in) {
        this.numCharactersExpected = in.get();
        this.halfPagePointer = UCS2Decoder81.getCodePageAsInt(in.get());
    }
}

