/*
 * Decompiled with CFR 0.152.
 */
package threegpp.charset.ucs2;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.HashSet;
import threegpp.charset.ucs2.UCS2Charset81;

public class UCS2Encoder81
extends CharsetEncoder {
    private static final float AVERAGE_BYTES_PER_CHAR = 1.012f;
    private static final float MAX_BYTES_PER_CHAR = 4.0f;
    private static final int MAX_TEXT_LENGTH = 255;
    private static final int CHAR_CODE_MASK = 255;
    private static final int INVALID_CHARACTER = -1;
    private static final int CODE_PAGE_MASK = 32640;
    private int numCharacters = 0;
    private int halfPagePointer = 0;
    private boolean onStart = true;

    UCS2Encoder81(UCS2Charset81 cs) {
        super(cs, 1.012f, 4.0f);
    }

    @Override
    protected CoderResult implFlush(ByteBuffer out) {
        out.put(Positions.TEXT_LENGTH.get(), (byte)this.numCharacters).put(Positions.CODE_PAGE.get(), UCS2Encoder81.getCodePageAsByte(this.halfPagePointer));
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected void implReset() {
        this.numCharacters = 0;
        this.halfPagePointer = 0;
        this.onStart = true;
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        if (in.remaining() + this.numCharacters > 255) {
            return CoderResult.unmappableForLength(this.numCharacters);
        }
        if (this.onStart) {
            if (this.haveNoSpaceForHeader(out)) {
                return CoderResult.OVERFLOW;
            }
            this.prepareHeader(out);
        }
        while (in.hasRemaining()) {
            int newByte = this.encodeCharacter(in.get());
            if (newByte == -1) {
                return CoderResult.unmappableForLength(in.position());
            }
            try {
                out.put((byte)newByte);
                ++this.numCharacters;
            }
            catch (BufferOverflowException whatever) {
                in.position(in.position() - 1);
                return CoderResult.OVERFLOW;
            }
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    public boolean isLegalReplacement(byte[] replacement) {
        return true;
    }

    @Override
    public boolean canEncode(char c) {
        return true;
    }

    @Override
    public boolean canEncode(CharSequence cs) {
        HashSet<Integer> pages = new HashSet<Integer>();
        int length = cs.length();
        int maxCodePages = 2;
        for (int i = 0; i < length; ++i) {
            pages.add(UCS2Encoder81.getCharHalfPage(cs.charAt(i)));
            int size = pages.size();
            if (size <= maxCodePages && (size != maxCodePages || pages.contains(0))) continue;
            return false;
        }
        return true;
    }

    private int encodeCharacter(int intChar) {
        int charHalfPagePointer = UCS2Encoder81.getCharHalfPage(intChar);
        int charCode = UCS2Encoder81.getCharCode(intChar);
        if (charHalfPagePointer == 0) {
            return intChar;
        }
        if (this.halfPagePointer == 0) {
            this.rememberPagePointer(charHalfPagePointer);
        } else if (this.halfPagePointer != charHalfPagePointer) {
            return -1;
        }
        return charCode;
    }

    private static int getCharHalfPage(int ch) {
        return ch & 0x7F80;
    }

    private static byte getCodePageAsByte(int character) {
        return (byte)(character >> 7);
    }

    private static int getCharCode(int ch) {
        return UCS2Encoder81.setMostSignificantBit(ch & 0xFF);
    }

    private void rememberPagePointer(int pagePointer) {
        this.halfPagePointer = pagePointer;
    }

    private void prepareHeader(ByteBuffer buffer) {
        buffer.put((byte)-127).position(buffer.position() + 2);
        this.onStart = false;
    }

    private static int setMostSignificantBit(int ch) {
        return ch | 0x80;
    }

    private boolean haveNoSpaceForHeader(ByteBuffer buffer) {
        return buffer.remaining() < Positions.values().length + 1;
    }

    static enum Positions {
        TEXT_LENGTH(1),
        CODE_PAGE(2);

        private int position;

        private Positions(int position) {
            this.position = position;
        }

        public int get() {
            return this.position;
        }
    }
}

