/*
 * Decompiled with CFR 0.152.
 */
package org.junit.extensions.dynamicsuite.engine;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.junit.extensions.dynamicsuite.engine.ClassScanner;
import org.junit.extensions.dynamicsuite.engine.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathScanner
implements ClassScanner {
    private List<String> foundClasses = new ArrayList<String>();
    private final boolean includeJars;

    public ClassPathScanner(boolean includeJars) {
        this.includeJars = includeJars;
        this.init();
    }

    @Override
    public List<String> listClassNames() {
        return this.foundClasses;
    }

    public boolean isIncludeJars() {
        return this.includeJars;
    }

    private void init() {
        List<String> classPathEntries = this.getClassPathEntries();
        this.scanForClasses(classPathEntries);
    }

    private List<String> getClassPathEntries() {
        String separator = this.getPathSeparator();
        String classpath = this.getClassPathString();
        StringTokenizer tokenizer = new StringTokenizer(classpath, separator);
        ArrayList<String> classPathEntries = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String entry = tokenizer.nextToken();
            classPathEntries.add(entry);
        }
        return classPathEntries;
    }

    private void scanForClasses(List<String> classPathEntries) {
        for (String entry : classPathEntries) {
            File entryFile = new File(entry);
            if (entryFile.isDirectory()) {
                this.addDirectory(entryFile);
                continue;
            }
            if (!this.includeJars) continue;
            this.addJar(entryFile);
        }
    }

    private void addDirectory(File entryFile) {
        DirectoryScanner directoryScanner = new DirectoryScanner(entryFile);
        this.foundClasses.addAll(directoryScanner.listClassNames());
    }

    private void addJar(File fromFile) {
        JarFile jar = this.loadJarFile(fromFile);
        if (jar != null) {
            this.loadJarEntries(jar);
        }
    }

    private void loadJarEntries(JarFile jar) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry element = entries.nextElement();
            String name = element.getName();
            if (!name.toLowerCase().endsWith(".class")) continue;
            String className = StringUtils.replace((String)name, (String)"/", (String)".");
            className = StringUtils.removeEnd((String)className, (String)".class");
            this.foundClasses.add(className);
        }
    }

    private JarFile loadJarFile(File jarFile) {
        try {
            URL jarURL = new URL("file:" + jarFile.getCanonicalPath());
            jarURL = new URL("jar:" + jarURL.toExternalForm() + "!/");
            JarURLConnection conn = (JarURLConnection)jarURL.openConnection();
            return conn.getJarFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getClassPathString() {
        return System.getProperty("java.class.path");
    }

    protected String getPathSeparator() {
        return System.getProperty("path.separator");
    }
}

