/*
 * Decompiled with CFR 0.152.
 */
package org.junit.extensions.dynamicsuite.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.extensions.dynamicsuite.engine.ClassScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryScanner
implements ClassScanner {
    public static final String CLASS_ENDING = ".class";
    private final File basePath;
    private final List<String> foundClassNames = new ArrayList<String>();

    public DirectoryScanner(File basePath) {
        this.basePath = basePath;
        this.recursiveAdd(basePath);
    }

    @Override
    public List<String> listClassNames() {
        return this.foundClassNames;
    }

    protected void recursiveAdd(File current) {
        if (current.isDirectory()) {
            File[] files;
            for (File file : files = current.listFiles()) {
                this.recursiveAdd(file);
            }
        } else {
            String basePathName = this.basePath.getAbsolutePath();
            String className = current.getAbsolutePath();
            if (className.toLowerCase().endsWith(CLASS_ENDING)) {
                className = this.extractClassName(basePathName, className);
                this.foundClassNames.add(className);
            }
        }
    }

    protected String extractClassName(String basePath, String classFileName) {
        String className = classFileName;
        className = StringUtils.removeStart((String)className, (String)basePath);
        className = StringUtils.removeStart((String)className, (String)File.separator);
        className = StringUtils.removeEnd((String)className, (String)CLASS_ENDING);
        className = StringUtils.replace((String)className, (String)File.separator, (String)".");
        return className;
    }
}

