/*
 * Decompiled with CFR 0.152.
 */
package org.junit.extensions.dynamicsuite.engine;

import java.io.File;
import org.junit.extensions.dynamicsuite.ClassPath;
import org.junit.extensions.dynamicsuite.Directory;
import org.junit.extensions.dynamicsuite.engine.ClassPathScanner;
import org.junit.extensions.dynamicsuite.engine.ClassScanner;
import org.junit.extensions.dynamicsuite.engine.DirectoryScanner;

public class ScannerFactory {
    private static final ScannerFactory instance = new ScannerFactory();

    public static ScannerFactory getInstance() {
        return instance;
    }

    private ScannerFactory() {
    }

    public ClassScanner createScanner(Class filterAnnotatedClass) throws IllegalAccessException, InstantiationException {
        ClassScanner directoryScanner = this.createDirectoryScanner(filterAnnotatedClass);
        if (directoryScanner == null) {
            return this.createClassPathScanner(filterAnnotatedClass);
        }
        return directoryScanner;
    }

    private ClassScanner createDirectoryScanner(Class filterAnnotatedClass) throws InstantiationException, IllegalAccessException {
        Directory annotation = filterAnnotatedClass.getAnnotation(Directory.class);
        if (annotation != null) {
            return new DirectoryScanner(new File(annotation.value()));
        }
        return null;
    }

    private ClassScanner createClassPathScanner(Class filterAnnotatedClass) throws InstantiationException, IllegalAccessException {
        ClassPath annotation = filterAnnotatedClass.getAnnotation(ClassPath.class);
        if (annotation != null) {
            return new ClassPathScanner(annotation.includeJars());
        }
        return null;
    }
}

