/*
 * Decompiled with CFR 0.152.
 */
package org.junit.extensions.dynamicsuite.suite;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.junit.extensions.dynamicsuite.Filter;
import org.junit.extensions.dynamicsuite.TestClassFilter;
import org.junit.extensions.dynamicsuite.engine.ClassScanner;
import org.junit.extensions.dynamicsuite.engine.ScannerFactory;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicSuite
extends ParentRunner<Runner> {
    public static final Logger log = Logger.getLogger(DynamicSuite.class.getName());
    private List<Runner> fRunners;
    private Class<?> testedClass;
    private List<Class<?>> filteredClasses = new ArrayList();
    private TestClassFilter filter;
    private File basePath;

    protected DynamicSuite(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    public DynamicSuite(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        this(klass);
        this.testedClass = klass;
        this.loadTestClasses();
        this.fRunners = builder.runners(klass, this.filteredClasses.toArray(new Class[this.filteredClasses.size()]));
    }

    private void loadTestClasses() throws InitializationError {
        ClassScanner scanner = null;
        try {
            scanner = ScannerFactory.getInstance().createScanner(this.testedClass);
            List<String> classNames = scanner.listClassNames();
            for (String name : classNames) {
                TestClassFilter testFilter = this.getFilter();
                if (!testFilter.include(name)) continue;
                this.filterByClass(name);
            }
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    private void filterByClass(String className) {
        try {
            Class<?> newTestClass = ClassLoader.getSystemClassLoader().loadClass(className);
            if (this.filter.include(newTestClass)) {
                this.filteredClasses.add(newTestClass);
            }
        }
        catch (ClassNotFoundException e) {
            log.info(e.getMessage());
        }
    }

    private Class<? extends TestClassFilter> getAnnotatedFilterClass() throws InitializationError {
        Filter annotation = this.testedClass.getAnnotation(Filter.class);
        if (annotation == null) {
            String string = String.format("class '%s' must have a Filter annotation", this.testedClass.getName());
            System.err.println(string);
            throw new InitializationError(string);
        }
        return annotation.value();
    }

    private TestClassFilter getFilter() throws InitializationError {
        if (this.filter == null) {
            try {
                this.filter = this.getAnnotatedFilterClass().newInstance();
            }
            catch (InitializationError e) {
                throw e;
            }
            catch (Exception e) {
                throw new InitializationError((Throwable)e);
            }
        }
        return this.filter;
    }

    protected List<Runner> getChildren() {
        return this.fRunners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        runner.run(notifier);
    }
}

