/*
 * Decompiled with CFR 0.152.
 */
package org.junit.extensions.dynamicsuite.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.junit.extensions.dynamicsuite.engine.ClassScanner;

public class DirectoryScanner
implements ClassScanner {
    public static final String CLASS_ENDING = ".class";
    public static final String SOURCE_ENDING = ".java";
    private final List<String> foundClassNamesOrdered = new ArrayList<String>();
    private final Set<String> foundClassNamesIndexed = new HashSet<String>();

    public DirectoryScanner(File basePath) {
        this.recursiveAdd(basePath, basePath);
    }

    public DirectoryScanner(File[] basePaths) {
        for (File basePath : basePaths) {
            this.recursiveAdd(basePath, basePath);
        }
    }

    @Override
    public List<String> listClassNames() {
        return this.foundClassNamesOrdered;
    }

    protected void recursiveAdd(File base, File current) {
        if (current.isDirectory()) {
            File[] files = current.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.recursiveAdd(base, file);
                }
            }
        } else {
            String basePathName = base.getAbsolutePath();
            String className = current.getAbsolutePath();
            String classNameLc = className.toLowerCase();
            if ((classNameLc.endsWith(CLASS_ENDING) || classNameLc.endsWith(SOURCE_ENDING)) && !this.foundClassNamesIndexed.contains(className = this.extractClassName(basePathName, className))) {
                this.foundClassNamesOrdered.add(className);
                this.foundClassNamesIndexed.add(className);
            }
        }
    }

    protected String extractClassName(String basePath, String classFileName) {
        String className = classFileName;
        className = StringUtils.removeStart((String)className, (String)basePath);
        className = StringUtils.removeStart((String)className, (String)File.separator);
        className = StringUtils.removeEnd((String)className, (String)CLASS_ENDING);
        className = StringUtils.removeEnd((String)className, (String)SOURCE_ENDING);
        className = StringUtils.replace((String)className, (String)File.separator, (String)".");
        return className;
    }
}

